package com.pcloud.common.enums;


import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/6 11:36
 */
public enum QrcodeTypeEnum {

    MAGIC("AUDIO_MAGIC", 0, "听画书", "AUDIO_MAGIC", "APP", true),

    REWARD("CLOCK", 1, "打卡书", "REWARD", "APP", true),

    PREVIEW_APP("VIDEO", 2, "预习课", "PREVIEW", "APP", true),

    PREVIEW_PRODUCT("VIDEO_SCHEDULE", 3, "预习课", "PREVIEW", "PRODUCT", true),

    ZSCORE("ZSCORE", 4, "查分书", "ZSCORE", "APP", true);
    /**
     * 类型
     */
    private String type;

    private Integer value;

    private String description;

    private String scene;

    private String typeCode;

    private Boolean isNeedCover;

    public static final Map<String, QrcodeTypeEnum> QRCODE_TYPE_MAP = new HashMap<>();

    QrcodeTypeEnum(String type, Integer value, String description, String scene, String typeCode, Boolean isNeedCover) {
        this.type = type;
        this.value = value;
        this.description = description;
        this.scene = scene;
        this.typeCode = typeCode;
        this.isNeedCover = isNeedCover;
    }

    static {
        Arrays.asList(values()).forEach((m) -> {
            QRCODE_TYPE_MAP.put(m.type, m);
        });
    }

    public String getType() {
        return type;
    }

    public Integer getValue() {
        return value;
    }

    public String getDescription() {
        return description;
    }

    public String getScene() {
        return scene;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public Boolean getNeedCover() {
        return isNeedCover;
    }
}
