package com.pcloud.common.exceptions;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.pcloud.common.entity.BasePageVO;
import com.pcloud.common.utils.ListUtils;

/**
 * 参数校验
 *
 * @author：songx
 * @date：2019年4月15日,下午3:01:35
 */
public class ParamCheck {
    
    /**
     * check number is null
     *
     * @param number
     * @param msg
     * @throws BizException
     * @author songx
     * @date 2019年4月23日, 下午3:06:03
     */
    public static void isNull(Number number, String msg) throws BizException {
        if (number == null) {
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), msg);
        }
    }
    
    /**
     * check boolean is null
     *
     * @param bool
     * @param msg
     * @throws BizException
     * @author songx
     * @date 2019年4月23日, 下午3:06:25
     */
    public static void isNull(Boolean bool, String msg) throws BizException {
        if (bool == null) {
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), msg);
        }
    }
    
    /**
     * check string is null
     *
     * @param string
     * @param msg
     * @throws BizException
     * @author songx
     * @date 2019年4月23日, 下午3:06:36
     */
    public static void isEmpty(String string, String msg) throws BizException {
        if (StringUtils.isEmpty(string)) {
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), msg);
        }
    }
    
    /**
     * check page number is null
     *
     * @param currentPage
     * @param numPerPage
     * @throws BizException
     * @author songx
     * @date 2019年4月23日, 下午3:07:07
     */
    public static void isNull(Integer currentPage, Integer numPerPage) throws BizException {
        if (currentPage == null || numPerPage == null || currentPage < 0 || numPerPage < 0) {
            throw BizException.PAGE_PARAM_DELETION;
        }
    }
    
    /**
     * check list is null
     *
     * @param list
     * @param msg
     * @throws BizException
     * @author songx
     * @date 2019年4月23日, 下午3:07:37
     */
    public static void isEmpty(List<?> list, String msg) throws BizException {
        if (ListUtils.isEmpty(list)) {
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), msg);
        }
    }
    
    /**
     * check bety[] is null
     *
     * @param bts
     * @param msg
     * @throws BizException
     * @author songx
     * @date 2019年4月23日, 下午3:07:37
     */
    public static void isEmpty(byte[] bts, String msg) throws BizException {
        if (bts == null || bts.length == 0) {
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), msg);
        }
    }
    
    /**
     * 校验分页参数校验分页参数
     *
     * @param basePageVO
     * @throws BizException
     */
    public static void pageParam(BasePageVO basePageVO) throws BizException {
        pageParam(basePageVO.getCurrentPage(), basePageVO.getNumPerPage());
    }
    
    /**
     * 校验分页参数
     *
     * @param currentPage 当前页
     * @param numPerPage 每页行数
     * @throws BizException
     */
    public static void pageParam(Integer currentPage, Integer numPerPage) throws BizException {
        if (currentPage == null || currentPage < 0 || numPerPage == null || numPerPage < 0) {
            throw BizException.PAGE_PARAM_DELETION;
        }
    }
    
}
