package com.pcloud.common.mq.dto;

import com.pcloud.common.dto.BaseDto;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * @Author: songx
 * @Date: 2019年07月11日, 14:52
 */
@Getter
@Setter
@ToString(callSuper = true)
public class ServerLinkDTO extends BaseDto {
    
    private static final long serialVersionUID = 2029227731936018946L;
    
    /**
     * 消费者服务名称
     */
    private String consumerAppName;
    
    /**
     * 消费者IP
     */
    private String consumerIp;
    
    /**
     * 消费者类名
     */
    private String consumerClassName;
    
    /**
     * 消费者方法名
     */
    private String consumerMethodName;
    
    /**
     * 生产者服务名称
     */
    private String produceAppName;
    
    /**
     * 生产者IP
     */
    private String produceIp;
    
    /**
     * 生产者类名
     */
    private String produceClassName;
    
    /**
     * 生产者方法名
     */
    private String produceMethodName;
    
    /**
     * 完整的调用链路
     */
    private String links;
    
}
