package com.pcloud.common.trade.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;

/**
 * @描述：问答支付dto
 * @作者：TianChao
 * @创建时间：2016年10月19日 上午10:26:11 
 * @版本：1.0
 */
@ApiModel(description = "立即付款dto")
public class PayParamVO implements Serializable{
	
	private static final long serialVersionUID = 1424201849099702707L;
	@ApiModelProperty(value = "商户id",dataType = "Long")
	private Long merchantId;
	/**
	 * 商品标识
	 */
    @ApiModelProperty(value = "商品标识",dataType = "Long")
	private Long productId;
	/**
	 * 商品数量
	 */
    @ApiModelProperty(value = "商品数量",dataType = "Integer")
	private Integer quantity;
	/**
	 * 规格id
	 */
    @ApiModelProperty(value = "规格id",dataType = "Long")
	private Long specId;
    @ApiModelProperty(value = "应用id",dataType = "Long")
	private Long appId;
    @ApiModelProperty(value = "地址id",dataType = "Long")
	private Long addressId;
    @ApiModelProperty(value = "isInvoice",dataType = "int")
	private int isInvoice;
    @ApiModelProperty(value = "发票内容",dataType = "String")
	private String invoiceContent;
    @ApiModelProperty(value = "发票抬头",dataType = "String")
	private String invoiceHeader;
	/**
	 * 发票抬头类型（0是个人，1是企业）
	 */
    @ApiModelProperty(value = "发票抬头类型（0是个人，1是企业）",dataType = "Integer")
	private Integer invoiceHeaderType;
	
	/**
	 * 证件号（公司为企业税号，个人为身份证号）
	 */
    @ApiModelProperty(value = "证件号（公司为企业税号，个人为身份证号）",dataType = "String")
	private String invoiceCredentialNum;
    @ApiModelProperty(value = "购物码",dataType = "String")
	private String buyCode;
    @ApiModelProperty(value = "电话",dataType = "String")
	private String phone;
    @ApiModelProperty(value = "isAskMore",dataType = "int")
	private int isAskMore;
	 /**
     * 购买服务人
     */
     @ApiModelProperty(value = "购买服务人",dataType = "String")
    private String serviceName;
    /**
     * 服务电话
     */
    @ApiModelProperty(value = "服务电话",dataType = "String")
    private String servicePhone;
    /**
     * 服务者邮箱
     */
    @ApiModelProperty(value = "服务者邮箱",dataType = "String")
    private String email;

    private BigDecimal price;

    private Long adviserId;

    private Long sceneId;

	private Map<String,Object> paramForApp;

	private int hasOwnPrice;

	private BigDecimal dealPrice;

	private Integer paymentSource;

	public Integer getPaymentSource() {
		return paymentSource;
	}

	public void setPaymentSource(Integer paymentSource) {
		this.paymentSource = paymentSource;
	}

	public BigDecimal getDealPrice() {
		return dealPrice;
	}

	public void setDealPrice(BigDecimal dealPrice) {
		this.dealPrice = dealPrice;
	}

	public int getHasOwnPrice() {
		return hasOwnPrice;
	}

	public void setHasOwnPrice(int hasOwnPrice) {
		this.hasOwnPrice = hasOwnPrice;
	}

	public Map<String, Object> getParamForApp() {
		return paramForApp;
	}

	public void setParamForApp(Map<String, Object> paramForApp) {
		this.paramForApp = paramForApp;
	}

	public Long getAdviserId() {
		return adviserId;
	}

	public void setAdviserId(Long adviserId) {
		this.adviserId = adviserId;
	}

	public Long getSceneId() {
		return sceneId;
	}

	public void setSceneId(Long sceneId) {
		this.sceneId = sceneId;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}


	public String getServiceName() {
		return serviceName;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	public String getServicePhone() {
		return servicePhone;
	}

	public void setServicePhone(String servicePhone) {
		this.servicePhone = servicePhone;
	}

	public int getIsAskMore() {
		return isAskMore;
	}

	public void setIsAskMore(int isAskMore) {
		this.isAskMore = isAskMore;
	}

	public Integer getInvoiceHeaderType() {
		return invoiceHeaderType;
	}

	public void setInvoiceHeaderType(Integer invoiceHeaderType) {
		this.invoiceHeaderType = invoiceHeaderType;
	}

	public String getInvoiceCredentialNum() {
		return invoiceCredentialNum;
	}

	public void setInvoiceCredentialNum(String invoiceCredentialNum) {
		this.invoiceCredentialNum = invoiceCredentialNum;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getBuyCode() {
		return buyCode;
	}

	public void setBuyCode(String buyCode) {
		this.buyCode = buyCode;
	}

	public int getIsInvoice() {
		return isInvoice;
	}

	public void setIsInvoice(int isInvoice) {
		this.isInvoice = isInvoice;
	}

	public String getInvoiceContent() {
		return invoiceContent;
	}

	public void setInvoiceContent(String invoiceContent) {
		this.invoiceContent = invoiceContent;
	}

	public String getInvoiceHeader() {
		return invoiceHeader;
	}

	public void setInvoiceHeader(String invoiceHeader) {
		this.invoiceHeader = invoiceHeader;
	}

	public Long getAddressId() {
		return addressId;
	}

	public void setAddressId(Long addressId) {
		this.addressId = addressId;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getMerchantId() {
		return merchantId;
	}

	public void setMerchantId(Long merchantId) {
		this.merchantId = merchantId;
	}

	public Long getProductId() {
		return productId;
	}

	public void setProductId(Long productId) {
		this.productId = productId;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public Long getSpecId() {
		return specId;
	}

	public void setSpecId(Long specId) {
		this.specId = specId;
	}


	@Override
	public String toString() {
		return "PayParamVO{" +
				"merchantId=" + merchantId +
				", productId=" + productId +
				", quantity=" + quantity +
				", specId=" + specId +
				", appId=" + appId +
				", addressId=" + addressId +
				", isInvoice=" + isInvoice +
				", invoiceContent='" + invoiceContent + '\'' +
				", invoiceHeader='" + invoiceHeader + '\'' +
				", invoiceHeaderType=" + invoiceHeaderType +
				", invoiceCredentialNum='" + invoiceCredentialNum + '\'' +
				", buyCode='" + buyCode + '\'' +
				", phone='" + phone + '\'' +
				", isAskMore=" + isAskMore +
				", serviceName='" + serviceName + '\'' +
				", servicePhone='" + servicePhone + '\'' +
				", email='" + email + '\'' +
				", price=" + price +
				", adviserId=" + adviserId +
				", sceneId=" + sceneId +
				", paramForApp=" + paramForApp +
				", hasOwnPrice=" + hasOwnPrice +
				", dealPrice=" + dealPrice +
				", paymentSource=" + paymentSource +
				'}';
	}
}
