package com.pcloud.common.utils.aliyun.test;

import static feign.Util.toByteArray;

import com.google.gson.Gson;
import com.huawei.mpc.client.MpcClient;
import com.huawei.mpc.client.MpcConfig;
import com.huawei.mpc.model.ObsObjInfo;
import com.huawei.mpc.model.thumbnail.CreateThumbnailRequest;
import com.huawei.mpc.model.thumbnail.CreateThumbnailResponse;
import com.huawei.mpc.model.thumbnail.QueryThumbTaskRequest;
import com.huawei.mpc.model.thumbnail.QueryThumbTaskResponse;
import com.huawei.mpc.model.transcoding.CreateTranscodingRequest;
import com.huawei.mpc.model.transcoding.CreateTranscodingResponse;
import com.huawei.mpc.model.transcoding.QueryTranscodingRequest;
import com.huawei.mpc.model.transcoding.QueryTranscodingResponse;
import com.huawei.mpc.model.transcoding.TextWatermark;

import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.FileException;
import com.pcloud.common.utils.aliyun.OssUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName com.pcloud.auditcenter.utils.test.MPCTest
 * @Author zhuyajie
 * @Description 转码
 * @Date 2020/5/25 17:34
 * @Version 1.0
 **/
@Slf4j
@RestController
@RequestMapping("mpcTest")
public class MPCTest {


    public static final String AK="8J56JHJN5P8OLR5ERKFU";
    public static final String SK="xAlBYlowAhwa9c1Wi4JsX7XkZGFlzlWW3CBHdZWJ";
    public static final String PROJECT_ID="07455135488025b22fe7c01fdb631c14";

    private static MpcClient initMpcClient(){
        MpcConfig mpcConfig = new MpcConfig();
        mpcConfig.setEndPoint("mpc.cn-east-2.myhuaweicloud.com");// 设置转码节点地址
        mpcConfig.setProjectId(PROJECT_ID);// 设置用户项目编号ProjectId
        mpcConfig.setSk(SK);// 设置sk
        mpcConfig.setAk(AK);// 设置ak
        MpcClient mpcClient = new MpcClient(mpcConfig);
        return mpcClient;
    }

    @RequestMapping(value = "transcodeJob", method = RequestMethod.GET)
    public void transcodeJob(@RequestParam("fileUrl") String fileUrl, @RequestParam("outPutUrl") String outPutUrl,
                              @RequestParam("ext") String ext) throws FileException {
//        String fileUrl = "oss/transcode/audio/mp3/test_20200529145343507.mp3";
//        String outPutUrl = "oss/transcode/audio/mp3/";
        // url=oss/transcode/video/mp4/7599ec23e9f8454f8897c4ca64a2df34.mp4
        Long templateId=null;
        if ("mp3".equals(ext)){
            templateId=104257L;
        } else {
            templateId =104256L;
        }
        transcodeJob("whlg-oss-test-001",fileUrl,templateId,"cn-east-2",outPutUrl);
    }

//    public static void main(String[] args) {
//        String fileUrl = "oss/transcode/video/mp4/7599ec23e9f8454f8897c4ca64a2df34.mp4";
//        String outPutUrl = "oss/transcode/video/mp4/";
//        transcodeJob("whlg-oss-test-002",fileUrl,104256L,"cn-east-2",outPutUrl);
////        getTranscodeJob("460368","test");
//    }

    private static void transcodeJob(String bucketName,String fileUrl, Long templateId,String location,String outputUrl){
        // 媒体处理服务构造方法
        MpcClient mpcClient = initMpcClient();
        //设置媒体处理服务请求参数
        CreateTranscodingRequest createTranscodingRequest = new CreateTranscodingRequest();

        //设置转码的输入文件路径参数，可通过华为云OBS对象存储服务控制台查看。
        ObsObjInfo input  = new ObsObjInfo();
        //设置输入桶名
        input.setBucket(bucketName);
        //设置源文件路径
        input.setObject(fileUrl);
        //设置输入桶所在区域
        input.setLocation(location);
        createTranscodingRequest.setInput(input);
        // 设置转码的输出文件路径参数，可通过华为云OBS对象存储服务控制台查看。
        ObsObjInfo output  = new ObsObjInfo();
        //设置输出桶名
        output.setBucket(bucketName);
        //设置输出文件路径
        output.setObject(outputUrl);
        //设置输出桶所在区域
        output.setLocation(location);
        createTranscodingRequest.setOutput(output);

        //设置转码模板ID
        List<Long> transTempIds = new ArrayList<Long>();
        transTempIds.add(templateId);
        createTranscodingRequest.setTransTemplateId(transTempIds);


        // 设置水印功能
        CreateTranscodingRequest.Watermark watermark = new CreateTranscodingRequest.Watermark();
//        watermark.setTemplateId("watermark_template_id");
        // 设置水印图片地址
//        ObsObjInfo watermarkInput  = new ObsObjInfo();
//        // 水印图片地址所在桶
//        watermarkInput.setBucket(bucketName);
//        // 水印图片地址所在路径
//        watermarkInput.setObject("objectKey");
//        // 水印图片地址所在区域
//        watermarkInput.setLocation(location);
//        watermark.setInput(watermarkInput);

        // 文字水印内容，内容需做Base64编码,
        // 示例：若想添加文字水印“测试文字水印”，那么Content的值为：5rWL6K+V5paH5a2X5rC05Y2w
        watermark.setTextContext("5rWL6K+V5paH5a2X5rC05Y2w");
        TextWatermark textWatermark = new TextWatermark();
        // 字体颜色。
        // 目前颜色支持black,blue,white,green,red,yellow,brown,gold,pink,orange,purple。
        // 默认颜色是white
        textWatermark.setFontColor("black");
        // 字体，当前支持fzyouh、msyh
        // 默认字体是msyh
        textWatermark.setFontName("fzyouh");
        // 字体大小。默认值：16，范围：(4, 120)
        textWatermark.setFontSize(16);
        watermark.setTextWatermark(textWatermark);
        List<CreateTranscodingRequest.Watermark> watermarks = new ArrayList<CreateTranscodingRequest.Watermark>();
        watermarks.add(watermark);
        CreateTranscodingRequest.Watermark[] watermarkArray = new CreateTranscodingRequest.Watermark[watermarks.size()];
        createTranscodingRequest.setWatermarks(watermarks.toArray(watermarkArray));


        //发送媒体处理服务请求
        CreateTranscodingResponse createTranscodingResponse = mpcClient.createTranscodingTask(createTranscodingRequest);
        //返回消息
        log.info(new Gson().toJson(createTranscodingResponse));
    }



    private static QueryTranscodingResponse getTranscodeJob(String taskId, String bucketName) throws FileException {
        MpcClient mpcClient = initMpcClient();
        //设置查询转码任务ID
        QueryTranscodingRequest queryTranscodingRequest=new QueryTranscodingRequest();
        queryTranscodingRequest.setTaskId(taskId);
        //发送查询转码任务请求
        QueryTranscodingResponse queryTranscodingResponse=mpcClient.queryTranscodingTask(queryTranscodingRequest);
        System.out.println(new Gson().toJson(queryTranscodingResponse));
        return queryTranscodingResponse;
    }

    @GetMapping("getTranscodeJob")
    public ResponseDto<?> getTranscodeJob(@RequestParam("taskId") String taskId){
        QueryTranscodingResponse response = getTranscodeJob(taskId,"test");
        return new ResponseDto<>(response);
    }


    @GetMapping("submitTranscodeJobMp3")
    public ResponseDto<?> submitTranscodeJobMp3(){
        String filePath = "E:\\KuGou\\Delacey - Dream It Possible.mp3";
        String fileName = "test";
        String str =OssUtils.submitTranscodeJobMp3(fileName,filePath);
        return new ResponseDto<>(str);
    }

    @GetMapping("submitTranscodeJobMp302")
    public ResponseDto<?>submitTranscodeJobMp302() throws IOException {
        String filePath = "E:\\KuGou\\Delacey - Dream It Possible.mp3";
        InputStream in = new FileInputStream(filePath);
        byte[] data = toByteArray(in);
        return new ResponseDto<>(OssUtils.submitTranscodeJobMp3(data,"test","mp3"));
    }

    @GetMapping("submitTranscodeJobMp303")
    public ResponseDto<?>submitTranscodeJobMp303() throws FileNotFoundException {
        String filePath = "E:\\KuGou\\Delacey - Dream It Possible.mp3";
        InputStream in = new FileInputStream(filePath);
        return new ResponseDto<>(OssUtils.submitTranscodeJobMp3(in,"test","mp3"));
    }

    @GetMapping("submitTranscodeJobMp4")
    public ResponseDto<?> submitTranscodeJobMp4(){
        String filePath = "C:\\Users\\HP\\Desktop\\temp\\test.mp4";
        String fileName = "test";
        String str =OssUtils.submitTranscodeJobMp4(fileName,filePath);
        return new ResponseDto<>(str);
    }

    @GetMapping("submitTranscodeJobMp402")
    public ResponseDto<?>submitTranscodeJobMp402() throws IOException {
        String filePath = "C:\\Users\\HP\\Desktop\\temp\\test.mp4";
        InputStream in = new FileInputStream(filePath);
        byte[] data = toByteArray(in);
        return new ResponseDto<>(OssUtils.submitTranscodeJobMp4(data,"test","mp4"));
    }

    @GetMapping("getOSSResult")
    public ResponseDto<?> getOSSResult(@RequestParam("transcodeJobId") String transcodeJobId){
        return new ResponseDto<>(OssUtils.getOSSResult(transcodeJobId));
    }

    @GetMapping("getOSSResultByRegion")
    public ResponseDto<?> getOSSResultByRegion(@RequestParam("transcodeJobId") String transcodeJobId, @RequestParam("buckectName") String buckectName){
        return new ResponseDto<>(OssUtils.getOSSResultByRegion(transcodeJobId,buckectName));
    }

    @GetMapping("submitTranscodeJobSync")
    public ResponseDto<?>submitTranscodeJobSync(@RequestParam("fileUrl") String fileUrl){
        return new ResponseDto(OssUtils.submitTranscodeJobSync(fileUrl));
    }

    @GetMapping("submitThumbnailRequest")
    public ResponseDto<?> submitThumbnailRequest(@RequestParam("fileUrl") String fileUrl){
        return new ResponseDto<>(OssUtils.submitSnapshotJob(fileUrl,10));
    }

    private static void createThumbnail(){
        MpcClient mpcClient = initMpcClient();

        // 设置创建截图模板的请求参数
        CreateThumbnailRequest createThumbnailRequest = new CreateThumbnailRequest();

        // 设置截图源文件地址
        ObsObjInfo input  = new ObsObjInfo();
        //OBS桶名
        input.setBucket("whlg-oss-test-002");
        //OBS下媒资路径
        input.setObject("oss/transcode/video/mp4/test_20200529160425176.mp4");
        //OBS桶所在区域
        input.setLocation("cn-east-2");
        createThumbnailRequest.setInput(input);

        // 设置截图后文件存放地址
        ObsObjInfo output  = new ObsObjInfo();
        output.setBucket("whlg-oss-test-002");
        output.setObject("oss/transcode/video/mp4/");
        output.setLocation("cn-east-2");
        createThumbnailRequest.setOutput(output);

        // 设置截图参数
        CreateThumbnailRequest.ThumbnailPara thumbnailPara = new CreateThumbnailRequest.ThumbnailPara();
        //采样类型。支持三种采样方式PERCENT、TIME和DOTS(根据时间间隔time，根据视频时长百分比percent，根据时间截图时的时间点数组dots，目前只支持TIME和DOTS两种方式)
        thumbnailPara.setType(CreateThumbnailRequest.ThumbnailPara.TypeEnum.TIME);
        thumbnailPara.setTime(12);
        thumbnailPara.setStartTime(3);
        thumbnailPara.setDuration(3);
        //设置最大长度，范围(380,3840)
        thumbnailPara.setMaxLength(480);
        //设置纵横比(min = 0, max = 1)
        thumbnailPara.setAspectRatio(0);
        //设置截图格式，0表示默认，1表示JPG格式
        thumbnailPara.setFormat(1);
        createThumbnailRequest.setThumbnailPara(thumbnailPara);

        // 发送创建截图任务请求给媒体处理服务
        CreateThumbnailResponse createThumbnailResponse = mpcClient.createThumbnailsTask(createThumbnailRequest);

        // 返回消息
        System.out.println(new Gson().toJson(createThumbnailResponse));
    }

    private static void getThumbnail(String taskId){
        MpcClient mpcClient = initMpcClient();

        // 设置创建水印模板的请求参数
        QueryThumbTaskRequest queryThumbTaskRequest = new QueryThumbTaskRequest();
        //根据任务ID查询，最多支持10个任务ID
        queryThumbTaskRequest.setTaskId(new String[]{taskId});

        // 发送查询截图任务请求给媒体处理服务
        QueryThumbTaskResponse queryThumbTaskResponse = mpcClient.queryThumbnailsTask(queryThumbTaskRequest);
        // 返回消息
        System.out.println(new Gson().toJson(queryThumbTaskResponse));
    }






}
