package com.pcloud.common.utils.json;

import java.io.IOException;
import java.util.Date;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

import com.pcloud.common.utils.DateUtils;

/**
 * @描述：将时间类型序列化为“yyyy-MM-dd hh:mm:ss”格式
 * @作者：shichunshan
 * @创建时间：2016年5月20日,上午11:31:10
 * @版本：1.0
 */
public class CustomDateSerializer extends JsonSerializer<Date>{

	@Override
	public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider)
			throws IOException, JsonProcessingException {
		// 线程安全，避免高并发下出错	modify at songx 2017-06-29
		synchronized (DateUtils.LONG_DATE_FORMAT) {
			String formattedDate = DateUtils.LONG_DATE_FORMAT.format(value);
			jgen.writeString(formattedDate);
		}
	}
	
}
