package com.pcloud.common.utils.json;

import java.io.IOException;
import java.util.Date;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

import com.pcloud.common.utils.DateUtils;

/**
 * 
 * @描述：将时间类型序列化为“yyyy-MM-dd”格式
 * @作者：songx
 * @创建时间：2016年11月16日,下午2:55:53
 * @版本：1.0
 */
public class DateSerializer extends JsonSerializer<Date>{

	@Override
	public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider)
			throws IOException, JsonProcessingException {
		// 线程安全，避免高并发下出错	modify at songx 2017-06-29
		synchronized (DateUtils.SHORT_DATE_FORMAT) {
			String formattedDate = DateUtils.SHORT_DATE_FORMAT.format(value);
			jgen.writeString(formattedDate);
		}
	}
	
}
