package com.pcloud.common.utils.json;

import java.io.IOException;
import java.time.LocalDate;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/**
 * 将localDate类型序列化为“yyyy-MM-dd”格式
 * @描述：
 * @作者：songx
 * @创建时间：2017年7月28日,下午1:21:39
 * @版本：1.0
 */
public class LocalDateSerializer extends JsonSerializer<LocalDate>{

	@Override
	public void serialize(LocalDate localDate, JsonGenerator jgen, SerializerProvider provider)
			throws IOException, JsonProcessingException {
		jgen.writeString(localDate.toString());
	}
	
}
