package com.pcloud.common.utils.json;

import java.io.IOException;
import java.time.LocalDateTime;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/**
 * 
 * @描述：将LocalDateTime时间类型序列化为“yyyy-MM-dd HH:mm:ss”格式
 * @作者：songx
 * @创建时间：2017年7月28日,下午1:25:12
 * @版本：1.0
 */
public class LocalDateTimeSerializer extends JsonSerializer<LocalDateTime>{

	@Override
	public void serialize(LocalDateTime localDateTime, JsonGenerator jgen, SerializerProvider provider)
			throws IOException, JsonProcessingException {
		jgen.writeString(localDateTime.withNano(0).toString().replace("T", " "));
	}
	
}
