package com.pcloud.common.utils.word.dto;

import org.apache.poi.xwpf.usermodel.UnderlinePatterns;

import lombok.Getter;
import lombok.Setter;

/**
 * @author：songx
 * @date：2017年12月7日,下午2:36:08
 */
@Getter
@Setter
public class RunTextDTO extends RunDTO {

    /**
     * 行文本
     */
    private String text;

    /**
     * 字体样式
     */
    private String font;

    /**
     * 字体大小
     */
    private int fontSize;

    /**
     * 是否加粗
     */
    private boolean bold;

    /**
     * 字体
     */
    private String fontFamily;

    /**
     * 下划线
     */
    private UnderlinePatterns underlinePatterns;

    /**
     * 文本
     *
     * @param text
     */
    public static RunTextDTO newText(String text) {
        return newText(text, 0, null, null);
    }

    /**
     * 文本
     *
     * @param text
     * @param fontSize
     */
    public static RunTextDTO newText(String text, int fontSize) {
        return newText(text, fontSize, null, null);
    }

    /**
     * 文本
     *
     * @param text
     * @param fontFamily
     * @param fontSize
     */
    public static RunTextDTO newText(String text, int fontSize, String fontFamily) {
        return newText(text, fontSize, fontFamily, null);
    }

    /**
     * 文本
     *
     * @param text
     * @param underlinePatterns
     */
    public static RunTextDTO newText(String text, UnderlinePatterns underlinePatterns) {
        return newText(text, 0, null, underlinePatterns);
    }

    /**
     * 文本
     *
     * @param text
     * @param fontFamily
     * @param fontSize
     * @param underlinePatterns
     */
    public static RunTextDTO newText(String text, int fontSize, String fontFamily,
            UnderlinePatterns underlinePatterns) {
        RunTextDTO runTextDTO = new RunTextDTO();
        runTextDTO.setText(text);
        runTextDTO.setFontFamily(fontFamily);
        runTextDTO.setFontSize(fontSize);
        runTextDTO.setUnderlinePatterns(underlinePatterns);
        return runTextDTO;
    }

    /**
     * 文本
     *
     * @param text
     */
    public static RunTextDTO newBold(String text) {
        return newBold(text, 0, null);
    }

    /**
     * 文本
     *
     * @param text
     * @param fontSize
     */
    public static RunTextDTO newBold(String text, int fontSize) {
        return newBold(text, fontSize, null);
    }

    /**
     * 文本
     *
     * @param text
     * @param fontFamily
     * @param fontSize
     */
    public static RunTextDTO newBold(String text, int fontSize, String fontFamily) {
        RunTextDTO runTextDTO = new RunTextDTO();
        runTextDTO.setText(text);
        runTextDTO.setFontFamily(fontFamily);
        runTextDTO.setFontSize(fontSize);
        runTextDTO.setBold(true);
        return runTextDTO;
    }

    /**
     * 空行使用
     */
    public static RunTextDTO newEmpty() {
        RunTextDTO runTextDTO = new RunTextDTO();
        runTextDTO.setText("");
        return runTextDTO;
    }

}
