package com.pcloud.solr;

import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;

/**
 * Description solr查询参数
 * @author PENG
 * @date 2018/4/24
 */
public class SolrQueryParam {

    /**
     * 查询条件
     */
    private String q = "*:*";

    /**
     * 过滤条件
     */
    private List<String> fq;

    /**
     * 排序
     */
    private Map<String, SolrQuery.ORDER> sort;

    /**
     * 分页，起始页
     */
    private Integer start = 0;

    /**
     * 分页，条数
     */
    private Integer rows = 20;

    /**
     * 默认查询字段
     */
    private String df = "title";

    /**
     * 返回字段
     */
    private String fl = "id,saleId,saleCode,typeId,typeCode,typeName,title,startDate,endDate,coverImg,description,createdUser,createdDate,lastModifiedDate,channelId,saleState,sceneCode,titleLength";

    public String getQ() {
        return q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public List<String> getFq() {
        return fq;
    }

    public void setFq(List<String> fq) {
        this.fq = fq;
    }

    public Map<String, SolrQuery.ORDER> getSort() {
        return sort;
    }

    public void setSort(Map<String, SolrQuery.ORDER> sort) {
        this.sort = sort;
    }

    public Integer getStart() {
        return start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getRows() {
        return rows;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public String getDf() {
        return df;
    }

    public void setDf(String df) {
        this.df = df;
    }

    public String getFl() {
        return fl;
    }

    public void setFl(String fl) {
        this.fl = fl;
    }

    @Override
    public String toString() {
        return "SolrQueryParam{" +
                "q='" + q + '\'' +
                ", fq='" + fq + '\'' +
                ", sort=" + sort +
                ", start=" + start +
                ", rows=" + rows +
                ", df='" + df + '\'' +
                ", fl='" + fl + '\'' +
                '}';
    }
}
