package com.pcloud.book.book.vo.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.book.book.vo.BookKeywordDetailVO;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookKeywordResponseVO implements Serializable {

    private static final long serialVersionUID = -1180965999128554190L;
    private Long id;

    /**
     * 关键词
     */
    @ApiModelProperty("关键词id")
    private String keyword;

    @ApiModelProperty("引导语")
    private String guide;

    /**
     * 适用范围（0：所有出版社,1：编辑）
     */
    @ApiModelProperty("0：精准匹配1：模糊匹配")
    private Integer matchingRule;

    @ApiModelProperty("出版id")
    private Long agentId;

    @ApiModelProperty("出版名称")
    private String agentName;

    @ApiModelProperty("编辑id")
    private Long editorId;

    @ApiModelProperty("编辑名称")
    private String editorName;

    @ApiModelProperty("适用范围（0：所有出版社,1：编辑）")
    private Integer scope;

    /**
     * 商品/应用id
     */
    private List<BookKeywordDetailVO> product;

}
