package com.pcloud.book.consumer.erp;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.erp.project.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository("erpConsr")
public class ErpConsr {
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(ErpConsr.class);

	@Autowired
	private ProjectService projectService;
	
	@ParamLog("根据书名获取等级")
	public Integer getBookServiceLevel(String bookName) throws BizException {
		try {
			return ResponseHandleUtil.parseResponse(projectService.getBookServiceLevel(bookName), Integer.class);
		} catch (Exception e) {
			LOGGER.error("获取资源基本信息[resourceService.mapByPass]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CONTENT_ERROR, "获取资源基本信息失败~!");
		}
	}
	

}
