package com.pcloud.book.cultivate.facade;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.cultivate.biz.CultivateBiz;
import com.pcloud.book.cultivate.dto.CreateCultivateDTO;
import com.pcloud.book.cultivate.dto.EnergyConsumptionDTO;
import com.pcloud.book.cultivate.dto.FishBallConversionDTO;
import com.pcloud.book.cultivate.dto.FishBallPickDTO;
import com.pcloud.book.cultivate.dto.SkillUseDTO;
import com.pcloud.book.cultivate.entity.CultivateBookUser;
import com.pcloud.book.cultivate.entity.CultivateRobotClassify;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@Api("养成")
@RestController("cultivateFacade")
@RequestMapping("cultivate")
public class CultivateFacade {

    @Autowired
    private CultivateBiz cultivateBiz;


    @ApiOperation("新增养成")
    @PostMapping("/createCultivate")
    public ResponseDto<?> createCultivate(
            @RequestBody CreateCultivateDTO createCultivateDTO
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.createCultivate(createCultivateDTO));
    }

    @ApiOperation("获取养成")
    @GetMapping("/getCultivate")
    public ResponseDto<?> getCultivate(
            @RequestParam("wechatUserId") @ApiParam("用户id") Long wechatUserId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getCultivate(wechatUserId));
    }

    @ApiOperation("新增养成分类关联")
    @PostMapping("/createCultivateRobotClassify")
    public ResponseDto<?> createCultivateRobotClassify(
            @RequestBody @ApiParam("养成分类关联") CultivateRobotClassify cultivateRobotClassify
            ) throws BizException, PermissionException {
        cultivateBiz.createCultivateRobotClassify(cultivateRobotClassify);
        return new ResponseDto<>();
    }

    @ApiOperation("能量消耗")
    @PostMapping("/energyConsumption")
    public ResponseDto<?> getCultivate(
            @RequestBody @ApiParam("养成分类关联")EnergyConsumptionDTO energyConsumptionDTO
    ) throws BizException, PermissionException {
        cultivateBiz.energyConsumption(energyConsumptionDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("鱼丸兑换")
    @PostMapping("/fishBallConversion")
    public ResponseDto<?> fishBallConversion(
            @RequestBody @ApiParam("鱼丸兑换") FishBallConversionDTO fishBallConversionDTO
    ) throws BizException, PermissionException {
        cultivateBiz.fishBallConversion(fishBallConversionDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("新增技能使用记录")
    @PostMapping("/addUseSkillRecord")
    public ResponseDto<?> addUseSkillRecord(
            @RequestBody @ApiParam("鱼丸兑换") SkillUseDTO skillUseDTO
    ) throws BizException, PermissionException {
        Long wechatUserId=skillUseDTO.getWechatUserId();
        cultivateBiz.addUseSkillRecord(wechatUserId,skillUseDTO);
        return new ResponseDto<>();
    }


    @ApiOperation("鱼丸摘取")
    @PostMapping("/fishBallPick")
    public ResponseDto<?> fishBallPick(
            @RequestBody @ApiParam("鱼丸摘取") FishBallPickDTO fishBallPickDTO
    ) throws BizException, PermissionException {
        cultivateBiz.fishBallPick(fishBallPickDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("待摘取鱼丸数量获取")
    @GetMapping("/getFishBallNotPick")
    public ResponseDto<?> getFishBallNotPick(
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getFishBallNotPick(cultivateId));
    }

    @ApiOperation("获取动态记录列表")
    @GetMapping("/getCultivateRecordList")
    public ResponseDto<?> getCultivateRecordList(
            @RequestParam Long wechatUserId,
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId, @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage
    ) throws BizException, PermissionException {
        if (currentPage == null || numPerPage == null || currentPage < 0 || numPerPage < 0) {
            throw BookBizException.PAGE_PARAM_DELETION;
        }
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(cultivateBiz.getCultivateRecordList(cultivateId,wechatUserId,currentPage,numPerPage));
    }

    @ApiOperation("获取陪伴天数")
    @GetMapping("/getLoginDays")
    public ResponseDto<?> getLoginDays(@RequestParam Long wechatUserId){
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(cultivateBiz.getLoginDays(wechatUserId));
    }

    @ApiOperation("获取排名")
    @GetMapping("/getRanking")
    public ResponseDto<?> getRanking(@RequestParam Long wechatUserId){
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(cultivateBiz.getRanking(wechatUserId));
    }

    @ApiOperation("分享")
    @GetMapping("shareMedal")
    public ResponseDto<?> shareMedal(@RequestParam Long wechatUserId){
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(cultivateBiz.shareMedal(wechatUserId));
    }

    @ApiOperation("获取剩余亮灯时间")
    @GetMapping("/getResidueLightTime")
    public ResponseDto<?> getResidueLightTime(
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getResidueLightTime(cultivateId));
    }

    @ApiOperation("小睿养成读者喜好书籍")
    @PostMapping("/createCultivateBookUser")
    public ResponseDto<?> createCultivateBookUser(
            @RequestBody CultivateBookUser cultivateBookUser
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.createCultivateBookUser(cultivateBookUser));
    }

    @ApiOperation("获取最后一次小睿养成读者喜好书籍")
    @GetMapping("/getLastCultivateBookUser")
    public ResponseDto<?> getLastCultivateBookUser(
            @RequestParam("wechatUserId") Long wechatUserId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getLastCultivateBookUser(wechatUserId));
    }

    @ApiOperation("获取搜索书籍记录列表")
    @GetMapping("/getBookSearchRecord")
    public ResponseDto<?> getBookSearchRecord(
            @CookieValue(value = "userInfo" ,required = false) String  userInfo,@RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }

        return new ResponseDto<>(cultivateBiz.getBookSearchRecord(wechatUserId,currentPage,numPerPage));
    }


}
