package com.pcloud.book.custom.facade;

import com.pcloud.book.custom.biz.CustomPlanBiz;
import com.pcloud.book.custom.biz.CustomPlanEmailBiz;
import com.pcloud.book.custom.biz.CustomReadPlanBiz;
import com.pcloud.book.custom.dto.CustomPlanEmailDto;
import com.pcloud.book.custom.entity.CustomPlan;
import com.pcloud.book.custom.entity.CustomReadPlan;
import com.pcloud.book.custom.vo.AddBookNameVO;
import com.pcloud.book.custom.vo.AddCustomPlan4UserVO;
import com.pcloud.book.custom.vo.AddSuggestionVO;
import com.pcloud.book.custom.vo.EditCustomPlanModuleVO;
import com.pcloud.book.custom.vo.ModuleSuggestionVO;
import com.pcloud.book.custom.vo.SuggestionListVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequestMapping("customPlan")
@RestController("customPlanFacade")
public class CustomPlanFacade {

    @Autowired
    private CustomPlanBiz customPlanBiz;
    @Autowired
    private CustomPlanEmailBiz customPlanEmailBiz;
    @Autowired
    private CustomReadPlanBiz customReadPlanBiz;

    @ApiOperation("创建定制方案")
    @PostMapping("createCustomPlan")
    ResponseDto<?> createCustomPlan(@RequestHeader String token, @RequestBody CustomPlan customPlan) {
        return new ResponseDto<>(customPlanBiz.createCustomPlan(customPlan));
    }

    @ApiOperation("复制定制方案")
    @GetMapping("copyCustomPlan")
    ResponseDto<?> copyCustomPlan(@RequestHeader String token, @RequestParam Integer planId) {
        customPlanBiz.copyCustomPlan(planId);
        return new ResponseDto<>();
    }

    @ApiOperation("修改定制方案")
    @PostMapping("updateCustomPlan")
    ResponseDto<?> updateCustomPlan(@RequestHeader String token, @RequestBody CustomPlan customPlan) {
        customPlanBiz.updateCustomPlan(customPlan);
        return new ResponseDto<>();
    }

    @ApiOperation("根据ID获取定制方案(平台端)")
    @GetMapping("getCustomPlanById")
    ResponseDto<?> getCustomPlanById(@RequestHeader String token, @RequestParam Integer planId) {
        return new ResponseDto<>(customPlanBiz.getCustomPlanById(planId));
    }

    @ApiOperation("根据ID获取定制方案(微信端)")
    @GetMapping("getCustomPlanById4Wechat")
    ResponseDto<?> getCustomPlanById4Wechat(@RequestParam Integer planId) {
        return new ResponseDto<>(customPlanBiz.getCustomPlanById(planId));
    }

    @ApiOperation("根据ID删除定制方案")
    @GetMapping("deleteCustomPlanById")
    ResponseDto<?> deleteCustomPlanById(@RequestHeader String token, @RequestParam Integer planId) {
        customPlanBiz.deleteCustomPlanById(planId);
        return new ResponseDto<>();
    }

    @ApiOperation("分页获取定制方案")
    @GetMapping("listCustomPlanByPage")
    ResponseDto<?> listCustomPlanByPage(@RequestHeader String token, @RequestParam Integer currentPage, @RequestParam Integer numPerPage,
                                        @RequestParam(value = "content", required = false) String content, @RequestParam(value = "useState", required = false) Integer useState,
                                        @RequestParam(value = "hasPdf", required = false) Integer hasPdf,
                                        @RequestParam(value = "robotType", required = false) Integer robotType,
                                        @RequestParam(value = "readType", required = false) Integer readType) {
        return new ResponseDto<>(customPlanBiz.listCustomPlanByPage(currentPage, numPerPage, content, useState, hasPdf,robotType, readType));
    }

    @ApiOperation("编辑方案模块")
    @PostMapping("editCustomPlanModule")
    ResponseDto<?> editCustomPlanModule(@RequestHeader String token, @RequestBody EditCustomPlanModuleVO editCustomPlanModuleVO) {
        customPlanBiz.editCustomPlanModule(editCustomPlanModuleVO);
        return new ResponseDto<>();
    }

    @ApiOperation("获取方案模块")
    @GetMapping("getCustomPlanModule")
    ResponseDto<?> getCustomPlanModule(@RequestHeader String token, @RequestParam Integer planId) {
        return new ResponseDto<>(customPlanBiz.getCustomPlanModule(planId));
    }

    @ApiOperation("获取方案模块(客户端)")
    @GetMapping("getCustomPlanModule4Wechat")
    ResponseDto<?> getCustomPlanModule4Wechat(@RequestParam Integer planId) {
        return new ResponseDto<>(customPlanBiz.getCustomPlanModule(planId));
    }

    @ApiOperation("分页获取定制方案问卷")
    @GetMapping("listPlanPaperByPage")
    ResponseDto<?> listPlanPaperByPage(@RequestHeader String token, @RequestParam Integer currentPage, @RequestParam Integer numPerPage,
                                       @RequestParam(value = "paperState", required = false) Integer paperState,
                                        @RequestParam(value = "content", required = false) String content) {
        return new ResponseDto<>(customPlanBiz.listPlanPaperByPage(currentPage, numPerPage, paperState, content));
    }

    @ApiOperation("作品或应用链接转短链")
    @GetMapping("getShortLinkUrl")
    ResponseDto<?> getShortLinkUrl(@RequestHeader String token, @RequestParam(value = "appId", required = false) Long appId,
                                   @RequestParam(value = "productId", required = false) Long productId,
                                   @RequestParam(value = "linkUrl") String linkUrl) {
        return new ResponseDto<>(customPlanBiz.getShortLinkUrl(appId, productId, linkUrl));
    }

    @ApiOperation("发送邮件提醒")
    @PostMapping("sendCustomPlanEmail")
    public ResponseDto<?> sendCustomPlanEmail(@RequestHeader("token") String token, @RequestBody CustomPlanEmailDto customPlanEmailDto)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(customPlanEmailBiz.sendCustomPlanEmail(customPlanEmailDto));
    }

    @ApiOperation("获取最后一次发送的邮件提醒")
    @GetMapping("getCustomPlanEmailByPlanId")
    public ResponseDto<?> getCustomPlanEmailByPlanId(@RequestHeader("token") String token, @RequestParam Integer customPlanId)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(customPlanEmailBiz.getCustomPlanEmailByPlanId(customPlanId));
    }

    @GetMapping("listSuggestion4Plan")
    @ApiOperation(value = "获取方案满意度记录", httpMethod = "GET")
    ResponseDto<?> listSuggestion4Plan(@RequestHeader String token, @RequestParam Integer currentPage, @RequestParam Integer numPerPage,
                                       @RequestParam(value = "startTime", required = false) String startTime, @RequestParam(value = "endTime", required = false) String endTime,
                                       @RequestParam(value = "search", required = false) String search, @RequestParam Integer planId,@RequestParam(value = "userType", required = false) Integer userType) {
        PageBeanNew<SuggestionListVO> page = customPlanBiz.listSuggestion4Plan(currentPage, numPerPage, startTime, endTime, search, planId,userType);
        return new ResponseDto<>(page);
    }

    @ApiOperation("查看评价详情")
    @GetMapping("getSuggestionInfo")
    ResponseDto<?> getSuggestionInfo(@RequestHeader String token, @RequestParam Integer batchId, @RequestParam Integer planId){
        List<ModuleSuggestionVO> resultList = customPlanBiz.getSuggestionInfo(batchId, planId);
        return new ResponseDto<>(resultList);
    }

    @ApiOperation(value = "客户端提交方案的意见反馈", httpMethod = "POST")
    @PostMapping("addSuggestion4Module")
    ResponseDto<?> addSuggestion4Module(@RequestBody @Validated AddSuggestionVO addSuggestionVO){
        Integer batchId = customPlanBiz.addSuggestion4Module(addSuggestionVO);
        return new ResponseDto<>(batchId);
    }

    @ApiOperation(value = "给用户发送方案后的埋点", httpMethod = "POST")
    @PostMapping("addCustomPlan4User")
    ResponseDto<?> addCustomPlan4User(@RequestBody @Validated AddCustomPlan4UserVO addCustomPlan4UserVO){
        Integer id = customPlanBiz.addCustomPlan4User(addCustomPlan4UserVO);
        return new ResponseDto<>(id);
    }

    @ApiOperation("获取用户定制单满意度填写权限")
    @GetMapping("getUserInputPermission")
    public ResponseDto<?>getUserInputPermission(@RequestParam("userWxId") String userWxId,@RequestParam("planId") Integer planId){
        Boolean canInput = customPlanBiz.getUserInputPermission(userWxId, planId);
        Map<String, Object> map = new HashMap<>();
        map.put("canInput", canInput);
        return new ResponseDto<>(map);
    }
    @ApiOperation(value = "提交需求定制单-埋点书籍以及serviceType", httpMethod = "POST")
    @PostMapping("addBookNameAndServiceType")
    ResponseDto<?> addBookNameAndServiceType(@RequestBody AddBookNameVO addBookNameVO){
        Integer id = customPlanBiz.addBookNameAndServiceType(addBookNameVO);
        return new ResponseDto<>(id);
    }

    @ApiOperation(value = "获取用户埋点书名以及类型", httpMethod = "GET")
    @GetMapping("getUserBookAdnServiceType")
    ResponseDto<?> getUserBookAdnServiceType(@RequestParam("wxId") String wxId, @RequestParam("robotWxId") String robotWxId, @RequestParam("type") Integer type){
        return new ResponseDto<>(customPlanBiz.getUserBookAdnServiceType(wxId, robotWxId, type));
    }

    @ApiOperation("根据id获取用户埋点书名")
    @GetMapping("getUserBookServiceById")
    ResponseDto<?> getUserBookServiceById(
            @RequestParam("userBookServiceId") Long userBookServiceId
    ){
        return new ResponseDto<>(customPlanBiz.getUserBookServiceById(userBookServiceId));
    }

    @ApiOperation("新增阅读计划")
    @PostMapping("addCustomReadPlan")
    ResponseDto<?> addCustomReadPlan(
            @RequestHeader("token") String token,
            @RequestBody CustomReadPlan customReadPlan
    )throws BizException, PermissionException{
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(customReadPlanBiz.addCustomReadPlan(customReadPlan));
    }

    @ApiOperation("修改阅读计划")
    @PostMapping("updateCustomReadPlan")
    ResponseDto<?> updateCustomReadPlan(
            @RequestHeader("token") String token,
            @RequestBody CustomReadPlan customReadPlan
    )throws BizException, PermissionException{
        SessionUtil.getToken4Redis(token);
        customReadPlanBiz.updateCustomReadPlan(customReadPlan);
        return new ResponseDto<>();
    }

    @ApiOperation("删除阅读计划")
    @GetMapping("deleteCustomReadPlan")
    ResponseDto<?> deleteCustomReadPlan(
            @RequestHeader("token") String token,
            @RequestParam("customReadPlanId") Long customReadPlanId
    )throws BizException, PermissionException{
        SessionUtil.getToken4Redis(token);
        customReadPlanBiz.deleteCustomReadPlan(customReadPlanId);
        return new ResponseDto<>();
    }

    @ApiOperation("获取阅读计划列表")
    @GetMapping("getCustomReadPlanList")
    ResponseDto<?> getCustomReadPlanList(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage,
            @RequestParam(value = "robotType",required = false) Integer robotType
    )throws BizException, PermissionException{
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(customReadPlanBiz.getCustomReadPlanList(currentPage,numPerPage,robotType));
    }

    @ApiOperation("根据id获取阅读计划")
    @GetMapping("getCustomReadPlanById")
    ResponseDto<?> getCustomReadPlanById(
            @RequestHeader("token") String token,
            @RequestParam("customReadPlanId") Long customReadPlanId
    )throws BizException, PermissionException{
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(customReadPlanBiz.getCustomReadPlanById(customReadPlanId));
    }

    @ApiOperation("复制阅读计划")
    @GetMapping("copyCustomReadPlanById")
    ResponseDto<?> copyCustomReadPlanById(
            @RequestHeader("token") String token,
            @RequestParam("customReadPlanId") Long customReadPlanId
    )throws BizException, PermissionException{
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(customReadPlanBiz.copyCustomReadPlanById(customReadPlanId));
    }


}
