package com.pcloud.book.custom.facade;

import com.pcloud.book.custom.biz.CustomTimeControlBiz;
import com.pcloud.book.custom.dto.CustomTimeControlDTO;
import com.pcloud.book.custom.dto.CustomTimeControlPageDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.ApiParam;

@RequestMapping("customTimeControl")
@RestController("customTimeControlFacade")
public class CustomTimeControlFacade {
    @Autowired
    private CustomTimeControlBiz customTimeControlBiz;

    @PostMapping("createCustomTimeControl")
    ResponseDto<?>  createCustomTimeControl(@RequestHeader("token") String token, @RequestBody CustomTimeControlDTO customTimeControlDTO){
        return new ResponseDto<>(customTimeControlBiz.createCustomTimeControl(customTimeControlDTO));
    }

    @PostMapping("updateCustomTimeControl")
    ResponseDto<?>  updateCustomTimeControl(@RequestHeader("token") String token, @RequestBody CustomTimeControlDTO customTimeControlDTO){
        customTimeControlBiz.updateCustomTimeControl(customTimeControlDTO);
        return new ResponseDto<>();
    }

    @GetMapping("getCustomTimeControlPage")
    ResponseDto<PageBeanNew<CustomTimeControlPageDTO>>  getCustomTimeControlPage(@RequestHeader("token") String token,
                                                                                 @RequestParam(value = "taskName",required = false) String taskName,
                                                                                 @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
                                                                                 @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage){
        return new ResponseDto<PageBeanNew<CustomTimeControlPageDTO>>( customTimeControlBiz.getCustomTimeControlPage(taskName,currentPage,numPerPage));
    }

    @GetMapping("getCustomTimeControlById")
    ResponseDto<CustomTimeControlDTO>  getCustomTimeControlById(@RequestHeader("token") String token,@RequestParam("id") Integer id){
        return new ResponseDto<CustomTimeControlDTO>(customTimeControlBiz.getCustomTimeControlById(id));
    }

    @GetMapping("deleteCustomTimeControlById")
    ResponseDto<?>  deleteCustomTimeControlById(@RequestHeader("token") String token, @RequestParam("id") Integer id){
        customTimeControlBiz.deleteCustomTimeControlById(id);
        return new ResponseDto<>();
    }

}
