package com.pcloud.book.pcloudkeyword.dao;

import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudkeyword.dto.PcloudRobotCountDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotResponseVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

public interface PcloudRobotDao extends BaseDao<PcloudRobot> {

    /**
     * c++心跳程序自动修改真实状态
     */
    void updateRealStatus(String wxId, Integer realStatus);

    PcloudRobot getByWxId(String wxId);

    PcloudRobot getPcloudRobotByType(Integer robotType,Integer groupRobotType);

    void updateWakeUpByClassifyIds(List<Integer> classifyList);

    void clearWakeUp();

    Map<String, RobotClassifyDTO> mapByIds4Classify(List<String> robotIds);

    List<RobotClassifyDTO> getAllPcloudRobot();

    List<RobotClassifyDTO> getAllPcloudRobotByType(Integer groupRobotType);

    /**
     * 根据编号获取小号
     * @param uniqueNumber
     * @return
     */
    PcloudRobot getByUniqueNumber(String uniqueNumber);

    void updatePcloudRobotByWxId(PcloudRobot pcloudRobot);

    List<String> getPcloudRobotByTypes(List<Integer> classifyIds);

    void updateRobotState(Map<String, Object> map);

    List<RobotClassifyDTO> listSelfRobotByClassify(Map<String, Object> paramMap);

    void updateRobotType(Map<String, Object> paramMap);

    List<String> getPcloudRobotByClassify(Integer classifyId);

    List<String> getPcloudRobotByRobotType(Integer classifyId,Integer groupRobotType);

    List<PcloudRobotCountDTO> getPcloudRobotCount(List<Long> classifyIds);

    PcloudRobotResponseVO getSelfRobotClassify(String robotId);
}
