package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.BookQrcodeWxworkDao;
import com.pcloud.book.book.entity.BookQrcodeWxwork;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.book.dao.impl.BookQrcodeWxworkDaoImpl
 * @Author zhuyajie
 * @Description 二维码配置企业微信码
 * @Date 2020/12/22 17:26
 * @Version 1.0
 **/
@Repository
public class BookQrcodeWxworkDaoImpl extends BaseDaoImpl<BookQrcodeWxwork> implements BookQrcodeWxworkDao {

    @Override
    public void deleteByQrcodeIdAndType(Long bookQrcodeId, Integer bookQrcodeType, Integer wxworkQrcodeType) {
        Map<String,Object> map = new HashMap<>();
        map.put("bookQrcodeId", bookQrcodeId);
        map.put("bookQrcodeType", bookQrcodeType);
        map.put("wxworkQrcodeType", wxworkQrcodeType);
        getSessionTemplate().delete(getStatement("deleteByQrcodeIdAndType"), map);
    }

    @Override
    public BookQrcodeWxwork getByQrcodeIdAndType(Long bookQrcodeId, Integer bookQrcodeType, Integer wxworkQrcodeType) {
        Map<String,Object> map = new HashMap<>();
        map.put("bookQrcodeId", bookQrcodeId);
        map.put("bookQrcodeType", bookQrcodeType);
        map.put("wxworkQrcodeType", wxworkQrcodeType);
        return getSessionTemplate().selectOne(getStatement("getByQrcodeIdAndType"), map);
    }

    @Override
    public List<BookQrcodeWxwork> getWxworkQrcodeByBook(Long bookId, Long channelId, Long adviserId, Integer wxworkQrcodeType) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("adviserId", adviserId);
        map.put("wxworkQrcodeType", wxworkQrcodeType);
        return getSessionTemplate().selectList(getStatement("getWxworkQrcodeByBook"), map);
    }
}
