package com.pcloud.book.personalstage.entity;

import com.pcloud.common.entity.BaseEntity;
import com.pcloud.contentcenter.resource.dto.ResourceOfficeItemDTO;
import com.pcloud.contentcenter.resource.dto.ResourcePdfItemDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel("定制化阶段跳转衔接语")
@Data
public class PersonalStageJumpLinkup extends BaseEntity {

    @ApiModelProperty("定制化阶段跳转id")
    private Long personalStageJumpId;

    @ApiModelProperty("衔接语")
    private String linkupContent;

    @ApiModelProperty("距离阶段开始时间")
    private Integer toStageStartTime;

    @ApiModelProperty("类型：1：文字；2：图片；6语音 7小程序")
    private Integer replyType;

    @ApiModelProperty("图片链接")
    private String picUrl;

    @ApiModelProperty("资源id")
    private Long resourceId;

    @ApiModelProperty("资源链接")
    private String resourceUrl;

    @ApiModelProperty("资源名称")
    private String resourceName;

    @ApiModelProperty("资源类型编码")
    private String resourceTypeCode;

    @ApiModelProperty("资源类型名称")
    private String resourceTypeName;

    @ApiModelProperty("文件类型")
    private String fileType;

    @ApiModelProperty("pdf转码后的单张图片集合")
    private List<ResourcePdfItemDTO> resourcePdfItems;

    @ApiModelProperty("文件转码后的单张图片集合")
    private List<ResourceOfficeItemDTO> resourceOfficeItemDTOs;

    @ApiModelProperty("文件大小")
    private Long fileSize;

    @ApiModelProperty("小程序主键id")
    private Long personalAppletsId;

    @ApiModelProperty("小程序宣传语")
    private String  slogan;

    @ApiModelProperty("小程序宣传图")
    private String  sloganImgUrl;


}