package com.pcloud.book.appeal.facade;

import org.codehaus.jackson.JsonParseException;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.pcloud.book.appeal.dto.BookAppealDto;
import com.pcloud.book.appeal.entity.BookAppeal;
import com.pcloud.book.book.dto.BookMainAdviserDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.permission.PermissionException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * 期刊申诉
 * 
 * @author:lili
 * @date 创建时间：2017年3月30日 下午3:24:07
 * @version 1.0
 * @return
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookAppealFacadeCloud", path = "book/v1.0/bookAppeal")
@Api(description = "期刊申诉外部服务")
public interface BookAppealFacade {

	/**
	 * 书刊申诉
	 * 
	 * @param token
	 * @param bookAppeal
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "书刊申诉", httpMethod = "POST")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
			@ApiImplicitParam(name = "bookAppeal", value = "书刊申诉实体", dataType = "BookAppeal", paramType = "body") })
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public ResponseDto<BookAppealDto> create(@RequestHeader("token") String token, @RequestBody BookAppeal bookAppeal)
			throws BizException, PermissionException;

	/**
	 * 获取申诉列表
	 * 
	 * @param token
	 * @param currentPage
	 *            当前页
	 * @param numPerPage
	 *            每页条数
	 * @param bookName
	 *            图书名称
	 * @param appealState
	 *            申诉状态
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "获取申诉列表", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
			@ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
			@ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
			@ApiImplicitParam(name = "bookName", value = "图书名称", dataType = "string", paramType = "query"),
			@ApiImplicitParam(name = "appealState", value = "申诉状态", dataType = "int", paramType = "query") })
	@RequestMapping(value = "list", method = RequestMethod.GET)
	public ResponseDto<PageBean> list(@RequestHeader("token") String token,
			@RequestParam(value = "currentPage", required = false) Integer currentPage,
			@RequestParam(value = "numPerPage", required = false) Integer numPerPage,
			@RequestParam(value = "bookName", required = false) String bookName,
			@RequestParam(value = "appealState", required = false) Integer appealState)
			throws BizException, PermissionException;

	/**
	 * 获取申诉详情
	 * 
	 * @param token
	 * @param bookAppealId
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "获取申诉详情", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
			@ApiImplicitParam(name = "bookAppealId", value = "图书申诉标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "getById", method = RequestMethod.GET)
	public ResponseDto<BookAppealDto> getById(@RequestHeader("token") String token,
			@RequestParam(value = "bookAppealId", required = false) Long bookAppealId)
			throws BizException, PermissionException;

	/**
	 * 申诉审核不通过
	 * 
	 * @param token
	 * @param bookAppeal
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "申诉审核不通过", httpMethod = "POST")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
			@ApiImplicitParam(name = "bookAppeal", value = "书刊申诉实体", dataType = "BookAppeal", paramType = "body") })
	@RequestMapping(value = "setupAudit", method = RequestMethod.POST)
	public ResponseDto<?> setupAudit(@RequestHeader("token") String token, @RequestBody BookAppeal bookAppeal)
			throws BizException, PermissionException;

	/**
	 * @Title: getAppealAdviserList
	 * @Description:获取申诉编辑列表（申诉编辑+被诉编辑）
	 * @param token
	 * @param bookAppealId
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 * @return: ResponseDto<?>
	 * @author: lihao
	 * @date: 2017年7月11日 下午3:37:15
	 */
	@ApiOperation(value = "获取申诉编辑列表（申诉编辑+被诉编辑）", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
			@ApiImplicitParam(name = "bookAppealId", value = "图书申诉标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "getAppealAdvisers", method = RequestMethod.GET)
	public ResponseDto<?> getAppealAdvisers(@RequestHeader("token") String token,
			@RequestParam(value = "bookAppealId", required = false) Long bookAppealId)
			throws BizException, PermissionException;

	/**
	 * 设置主编辑，申诉审核通过
	 * 
	 * @param token
	 * @param bookMainAdviserDto
	 *            设置主编辑Dto
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "设置主编辑，申诉审核通过", httpMethod = "POST")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
			@ApiImplicitParam(name = "bookMainAdviserDto", value = "设置主编辑Dto", dataType = "BookMainAdviserDto", paramType = "body") })
	@RequestMapping(value = "setMainAdviser", method = RequestMethod.POST)
	public ResponseDto<?> setMainAdviser(@RequestHeader("token") String token,
			@RequestBody BookMainAdviserDto bookMainAdviserDto)
			throws BizException, PermissionException;

	/**
	 * 获取申诉结果
	 * 
	 * @param token
	 * @param bookAppealId
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "获取申诉结果", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
			@ApiImplicitParam(name = "bookAppealId", value = "图书申诉标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "getAppealResult", method = RequestMethod.GET)
	public ResponseDto<?> getAppealResult(@RequestHeader("token") String token,
			@RequestParam(value = "bookAppealId") Long bookAppealId)
			throws BizException, PermissionException;
}
