/**
 * 
 */
package com.pcloud.book.consumer.message;

import com.pcloud.common.core.biz.TemplateQueueBiz;
import com.pcloud.common.core.constant.WechatCode;
import com.pcloud.common.core.dto.TemplateMessageDto;
import com.pcloud.common.exceptions.BizException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @描述：发送模板消息
 * @作者：songx
 * @创建时间：2016年11月18日,上午9:56:03
 * @版本：1.0
 */
@Component("templetConsr")
public class TemplateConsr {
	
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(TemplateConsr.class);

	@Autowired
	private TemplateQueueBiz templateQueueBiz;

	/**
	 * 发送模板消息topic(管理公众号)
	 */
	public void sendManage(String SceneCode, Long sendPartyId, Long receivePartyId, String receivePartyRole, String url,
			Map<String, String> temParam, String sendType, boolean isApp) throws BizException {
		LOGGER.info("【模板消息(消)】发送模板消息topic(管理公众号),<PARAM>.[receivePartyId]=" + receivePartyId + ",[sendPartyId]="
				+ sendPartyId + ",[temParam]=" + temParam.toString());
		// 组装参数对象
		TemplateMessageDto templateMessageDto = new TemplateMessageDto();
		templateMessageDto.setSceneCode(SceneCode);
		templateMessageDto.setSendPartyId(sendPartyId);
		templateMessageDto.setSendPartyRole(WechatCode.AGENT.value);
		templateMessageDto.setUrl(url);
		templateMessageDto.setTemParam(temParam);
		templateMessageDto.setSendType(sendType);
		templateMessageDto.setReceivePartyId(receivePartyId);
		templateMessageDto.setReceivePartyRole(receivePartyRole);
		templateMessageDto.setIsApp(isApp);
		try {
			templateQueueBiz.sendMessageQueue(templateMessageDto);
		} catch (Exception e) {
			LOGGER.error("【模板消息(消)】发送模板消息topic(管理公众号),<ERROR>.[sendMessageQueue]:" + e.getMessage(), e);
		}
	}

	public void sendOperate(String SceneCode, Long sendPartyId, Long wechatUserId, String url,
						   Map<String, String> temParam, String sendType, boolean isApp) throws BizException {
		// 组装参数对象
		TemplateMessageDto templateMessageDto = new TemplateMessageDto();
		templateMessageDto.setSceneCode(SceneCode);
		templateMessageDto.setSendPartyId(sendPartyId);
		templateMessageDto.setSendPartyRole(WechatCode.CHANNEL.value);
		templateMessageDto.setUrl(url);
		templateMessageDto.setTemParam(temParam);
		templateMessageDto.setSendType(sendType);
		templateMessageDto.setWechatUserId(wechatUserId);
		templateMessageDto.setIsApp(isApp);
		try {
			templateQueueBiz.sendMessageQueue(templateMessageDto);
		} catch (Exception e) {
			LOGGER.error("【模板消息(消)】发送模板消息topic(运营号),<ERROR>.[sendMessageQueue]:" + e.getMessage(), e);
		}
	}
	 
}
