package com.pcloud.book.keywords.biz;

import com.pcloud.book.keywords.dto.SelfRobotBookRecordDTO;
import com.pcloud.book.keywords.entity.SelfRobotKeyword;
import com.pcloud.book.keywords.vo.GuideWordVO;
import com.pcloud.book.keywords.vo.LabelVO;
import com.pcloud.book.keywords.vo.SelfRobotReplyVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface SelfRobotKeywordBiz {
    void batchAddSelfRobotKeyword(Long partyId, List<SelfRobotKeyword> selfRobotKeywords);

    void updateSelfRobotKeyword(Long partyId, SelfRobotKeyword selfRobotKeyword);

    void deleteSelfRobotKeyword(Long id);

    PageBeanNew<SelfRobotKeyword> getSelfRobotKeywordList(Long bookGroupId, String keyword, Integer currentPage, Integer numPerPage);

    void updateSelfRobotKeywordSeqNum(SelfRobotKeyword selfRobotKeyword);

    String getAppOrProductServeUrl(Long bookGroupId, Long serveId, String serveType, String serveUrl);

    List<LabelVO> listLabelByType(Integer type);

    List<SelfRobotReplyVO> getReplyByLabel(Integer type, Long labelId, String robotId, String wxUserId);

    List<SelfRobotReplyVO> getReplyByKeyWord(Integer type, String keyWord, String robotId, String wxUserId);

    List<GuideWordVO> getGuideWordListByType(Integer type);

    List<SelfRobotReplyVO> getReplyBuyGuide(Integer type, Integer id, String robotId, String wxUserId);

    String getResource(Integer id, String robotId, String wxUserId);

    String joinGroup(Integer id, String robotId, String wxUserId);

    void sendWhenNoReply(Integer id, String robotId, String wxUserId);

    List<SelfRobotKeyword> getListByBookGroupId(Long bookGroupId);

    PageBeanNew<SelfRobotBookRecordDTO> getSelfRobotBookRecordList(Integer currentPage, Integer numPerPage);

    void exportSelfRobotBookRecord(String systemCode,Long partyId);

    Boolean hasKeyword (Long bookGroupId);

    SelfRobotKeyword getById(Long id);
}
