package com.pcloud.book.keywords.facade;

import com.pcloud.book.keywords.entity.NotKeywordTemplate;
import com.pcloud.book.keywords.entity.SelfRobotKeyword;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api("个人号非关键词关键词")
public interface NotKeywordFacade {

    @ApiOperation("新增非关键词回复模板")
    @PostMapping("createNotKeywordTemplate")
    ResponseDto<?> createNotKeywordTemplate(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("非关键词回复模板") NotKeywordTemplate notKeywordTemplate
    ) throws BizException, PermissionException;

    @ApiOperation("删除非关键词回复模板")
    @GetMapping("deleteNotKeywordTemplate")
    ResponseDto<?> deleteNotKeywordTemplate(
            @RequestHeader("token") String token,
            @RequestParam @ApiParam("非关键词回复模板id") Long id
    ) throws BizException, PermissionException;

    @ApiOperation("获取非关键词回复模板列表")
    @GetMapping("getNotKeywordTemplateList")
    ResponseDto<?> getNotKeywordTemplateList(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("获取非关键词回复模板")
    @GetMapping("getNotKeywordTemplate")
    ResponseDto<?> getNotKeywordTemplate(
            @RequestHeader("token") String token,
            @RequestParam @ApiParam("非关键词回复模板id") Long id
    ) throws BizException, PermissionException;

}
