package com.pcloud.book.pcloudkeyword.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.consumer.content.ResourceConsr;
import com.pcloud.book.keywords.enums.ReplyTypeEnum;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotBiz;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotDao;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotWelcomeDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.book.pcloudkeyword.enums.WelcomeReplyTypeEnum;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.contentcenter.resource.dto.ResourceDTO;
import com.pcloud.resourcecenter.product.dto.ProductDto;
import com.pcloud.resourcecenter.product.dto.ProductTypeDto;
import com.sdk.wxgroup.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Component("pcloudRobotBiz")
public class PcloudRobotBizImpl implements PcloudRobotBiz {

    @Autowired
    private PcloudRobotDao pcloudRobotDao;
    @Autowired
    private PcloudRobotWelcomeDao pcloudRobotWelcomeDao;
    @Autowired
    private ResourceConsr resourceConsr;

    @Override
    public void createPcloudRobot(PcloudRobot pcloudRobot) {
        pcloudRobotDao.insert(pcloudRobot);
    }

    @Override
    @ParamLog
    public PageBeanNew<PcloudRobot> getPcloudRobotList(String nickName, Integer currentPage, Integer numPerPage) {
        if (currentPage == null || currentPage < 0 || numPerPage == null || numPerPage <= 0) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "分页参数错误");
        }
        Map<String, Object> map = new HashMap<>();
        map.put("nickName", nickName);
        PageBeanNew<PcloudRobot> pageBeanNew = pcloudRobotDao.listPageNew(new PageParam(currentPage, numPerPage), map, "getPcloudRobotList");
        for (PcloudRobot pcloudRobot : pageBeanNew.getRecordList()) {
            List<PcloudRobotWelcome> robotWelcomeList = pcloudRobotWelcomeDao.getRobotWelcomeListByPcloudRobotId(pcloudRobot.getId());
            fillRobotWelcome(robotWelcomeList);
            pcloudRobot.setRobotWelcomeList(robotWelcomeList);
        }
        return pageBeanNew;
    }

    @Override
    @ParamLog
    @Transactional(rollbackFor = Exception.class)
    public void batchUpdatePcloudRobotWelcome(List<PcloudRobotWelcome> robotWelcomeList) {
        if (ListUtils.isEmpty(robotWelcomeList)){
            return;
        }
        Long pcloudRobotId = robotWelcomeList.get(0).getPcloudRobotId();
        pcloudRobotWelcomeDao.deleteByPcloudRobotId(pcloudRobotId);
        pcloudRobotWelcomeDao.batchInsert(robotWelcomeList);
    }

    @Override
    @ParamLog
    public PcloudRobot getPcloudRobot(Long id) {
        PcloudRobot pcloudRobot = pcloudRobotDao.getById(id);
        if(pcloudRobot != null) {
            List<PcloudRobotWelcome> robotWelcomeList = pcloudRobotWelcomeDao.getRobotWelcomeListByPcloudRobotId(pcloudRobot.getId());
            fillRobotWelcome(robotWelcomeList);
            pcloudRobot.setRobotWelcomeList(robotWelcomeList);
        }
        return pcloudRobot;
    }

    @Override
    public void sendWelcomeReply(String robotWxId, String userWxId, String ip) {
        Map<String, Object> map = new HashMap<>();
        map.put("robotWxId", robotWxId);
        PcloudRobot pcloudRobot = (PcloudRobot)pcloudRobotDao.getBy(map, "getByRobotWxId");
        if(pcloudRobot != null) {
            List<PcloudRobotWelcome> robotWelcomeList = pcloudRobotWelcomeDao.getRobotWelcomeListByPcloudRobotId(pcloudRobot.getId());
            fillRobotWelcome(robotWelcomeList);
            for (PcloudRobotWelcome robotWelcome : robotWelcomeList) {
                Integer replyType = robotWelcome.getReplyType();
                if(WelcomeReplyTypeEnum.TEXT.value.equals(replyType)) {
                    SendTextMessageVO sendTextMessageVO = new SendTextMessageVO();
                    sendTextMessageVO.setContent(robotWelcome.getContent());
                    sendTextMessageVO.setAltId(robotWxId);
                    sendTextMessageVO.setWxGroupId(userWxId);
                    sendTextMessageVO.setIp(ip);
                    sendTextMessageVO.setCode(SendMessageTypeEnum.SELF.getCode());
                    WxGroupSDK.sendTextMessage(sendTextMessageVO);
                } else if(WelcomeReplyTypeEnum.IMAGE.value.equals(replyType)) {
                    SendPicMessageVO sendPicMessageVO = new SendPicMessageVO();
                    sendPicMessageVO.setWxGroupId(userWxId);
                    sendPicMessageVO.setAltId(robotWxId);
                    sendPicMessageVO.setPicUrl(robotWelcome.getPicUrl());
                    sendPicMessageVO.setIp(ip);
                    sendPicMessageVO.setCode(SendMessageTypeEnum.SELF.getCode());
                    WxGroupSDK.sendPicMessage(sendPicMessageVO);
                } else if(WelcomeReplyTypeEnum.RESOURCE.value.equals(replyType)) {
                    SendFileVO sendFileVO = new SendFileVO();
                    sendFileVO.setFileUrl(robotWelcome.getResourceUrl());
                    sendFileVO.setFileName(robotWelcome.getResourceName());
                    sendFileVO.setIp(ip);
                    sendFileVO.setAltId(robotWxId);
                    sendFileVO.setWxId(userWxId);
                    sendFileVO.setCode(SendMessageTypeEnum.SELF.getCode());
                    WxGroupSDK.sendFile(sendFileVO);
                }
            }
        }
    }

    @ParamLog("填充欢迎语回复")
    private void fillRobotWelcome(List<PcloudRobotWelcome> robotWelcomeList) {
        if(ListUtils.isEmpty(robotWelcomeList)){
            return;
        }
        List<Long> resourceIds=new ArrayList<>();
        for (PcloudRobotWelcome robotWelcome : robotWelcomeList){
            Integer type = robotWelcome.getReplyType();
            if (WelcomeReplyTypeEnum.RESOURCE.value.equals(type)){
                resourceIds.add(robotWelcome.getResourceId());
            }
        }
        Map<Long, ResourceDTO> resourceDTOMap=new HashMap<>();
        if (!ListUtils.isEmpty(resourceIds)){
            resourceDTOMap = resourceConsr.mapByIds(resourceIds);
        }
        for (PcloudRobotWelcome robotWelcome : robotWelcomeList){
            Integer type = robotWelcome.getReplyType();
            if (WelcomeReplyTypeEnum.RESOURCE.value.equals(type)){
                ResourceDTO resourceDTO = resourceDTOMap.get(robotWelcome.getResourceId());
                if (resourceDTO != null){
                    robotWelcome.setResourceName(resourceDTO.getResourceName());
                    robotWelcome.setResourceUrl(resourceDTO.getFileUrl());
                    robotWelcome.setResourceTypeCode(resourceDTO.getTypeCode());
                    robotWelcome.setResourceTypeName(resourceDTO.getTypeName());
                    robotWelcome.setFileType(resourceDTO.getFileType());
                    robotWelcome.setFileSize(resourceDTO.getFileSize());
                    robotWelcome.setResourcePdfItems(resourceDTO.getResourcePdfItems());
                    robotWelcome.setResourceOfficeItemDTOs(resourceDTO.getResourceOfficeItemDTOs());
                }
            }
        }
    }
}
