package com.pcloud.book.pcloudkeyword.facade;

import com.pcloud.book.pcloudkeyword.biz.PcloudRobotBiz;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api("全平台个人号配置")
@RestController("pcloudRobot")
@RequestMapping("pcloudRobotFacade")
public class PcloudRobotFacade {

    @Autowired
    private PcloudRobotBiz pcloudRobotBiz;

    @ApiOperation("新增全平台机器人")
    @PostMapping("/createPcloudRobot")
    ResponseDto<?> createPcloudRobot(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("全平台个人号") PcloudRobot pcloudRobot
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.createPcloudRobot(pcloudRobot);
        return new ResponseDto<>();
    }

    @ApiOperation("获取全平台个人号列表")
    @GetMapping("/getPcloudRobotList")
    ResponseDto<?> getPcloudRobotList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "nickName", required = false) @ApiParam("昵称") String nickName,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotBiz.getPcloudRobotList(nickName,currentPage,numPerPage));
    }


    @ApiOperation("更新全平台个人号欢迎语")
    @PostMapping("/batchUpdatePcloudRobotWelcome")
    ResponseDto<?> batchUpdatePcloudRobotWelcome(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("全平台个人号欢迎语列表") List<PcloudRobotWelcome> robotWelcomeList
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.batchUpdatePcloudRobotWelcome(robotWelcomeList);
        return new ResponseDto<>();
    }

    @ApiOperation("获取全平台个人号信息")
    @GetMapping("/getPcloudRobot")
    ResponseDto<?> getPcloudRobot(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("id") Long id
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotBiz.getPcloudRobot(id));
    }


}
