package com.pcloud.book.riddle.dao;

import com.pcloud.book.riddle.dto.RiddleCouponDTO;
import com.pcloud.book.riddle.entity.RiddleCoupon;
import com.pcloud.common.core.dao.BaseDao;

/**
 * @描述：自定义优惠券
 * @作者：zhuyajie
 * @创建时间：10:24 2019/11/7
 * @版本：1.0
 */
public interface RiddleCouponDao extends BaseDao<RiddleCoupon> {

    /**
     * 根据编辑获取优惠券设置
     * @param adviserId
     * @return
     */
    public RiddleCouponDTO getByAdviser(Long adviserId);

    /**
     * 删除自定义优惠券设置
     * @param adviserId
     */
    void deleteByAdviser(Long adviserId);
}
