package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @描述：书刊基金Dto
 * @作者：lihao
 * @创建时间：2016年7月14日,下午2:30:06
 * @版本：1.0
 */
public class BookFundDto extends BaseDto {

    /**
     * 序列号
     */
    private static final long serialVersionUID = 5567420011749503883L;


    /**
     * 书刊基金标识
     */
    private Long bookFundId;

    /**
     * 书刊标识
     */
    private Long bookId;

    /**
     * 基金名称
     */
    private String fundName;

    /**
     * 购买金额
     */
    private BigDecimal purchaseMoney;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 创建人
     */
    private Long createdUser;

    /**
     * 最后修改人
     */
    private Long lastModifiedUser;

    /**
     * 操作人
     */
    private String operateUserName;

    /**
     * 书刊基金总额
     */
    private BigDecimal fundMoneySum;

    /**
     * 操作按钮(button 0（正常），1（修改），2 （删除/取消）)
     */
    private Integer button;

    /**
     * 挂牌/合同编号
     */
    private String contractNo;
    /**
     * 批次号
     */
    private String batchNumber;

    /**
     * 是否代理模式-新增于2018-8-6
     */
    private Integer proxyMode;

    /**
     * 转让方-新增于2018-8-6
     */
    private String transferor;

    /**
     * 是否为受让方
     */
    private Integer isTransferor;

    public Integer getIsTransferor() {
        return isTransferor;
    }

    public void setIsTransferor(Integer isTransferor) {
        this.isTransferor = isTransferor;
    }

    public Long getBookFundId() {
        return bookFundId;
    }

    public void setBookFundId(Long bookFundId) {
        this.bookFundId = bookFundId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getFundName() {
        return fundName;
    }

    public void setFundName(String fundName) {
        this.fundName = fundName;
    }

    public BigDecimal getPurchaseMoney() {
        return purchaseMoney;
    }

    public void setPurchaseMoney(BigDecimal purchaseMoney) {
        this.purchaseMoney = purchaseMoney;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Long getCreatedUser() {
        return createdUser;
    }

    public void setCreatedUser(Long createdUser) {
        this.createdUser = createdUser;
    }

    public Long getLastModifiedUser() {
        return lastModifiedUser;
    }

    public void setLastModifiedUser(Long lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }


    public BigDecimal getFundMoneySum() {
        return fundMoneySum;
    }

    public void setFundMoneySum(BigDecimal fundMoneySum) {
        this.fundMoneySum = fundMoneySum;
    }

    public String getOperateUserName() {
        return operateUserName;
    }

    public void setOperateUserName(String operateUserName) {
        this.operateUserName = operateUserName;
    }

    public Integer getButton() {
        return button;
    }

    public void setButton(Integer button) {
        this.button = button;
    }

    public String getContractNo() {
        return contractNo;
    }

    public void setContractNo(String contractNo) {
        this.contractNo = contractNo;
    }

    public String getBatchNumber() {
        return batchNumber;
    }

    public void setBatchNumber(String batchNumber) {
        this.batchNumber = batchNumber;
    }

    public Integer getProxyMode() {
        return proxyMode;
    }

    public void setProxyMode(Integer proxyMode) {
        this.proxyMode = proxyMode;
    }

    public String getTransferor() {
        return transferor;
    }

    public void setTransferor(String transferor) {
        this.transferor = transferor;
    }

    @Override
    public String toString() {
        return "BookFundDto{" +
                "bookFundId=" + bookFundId +
                ", bookId=" + bookId +
                ", fundName='" + fundName + '\'' +
                ", purchaseMoney=" + purchaseMoney +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", createdUser=" + createdUser +
                ", lastModifiedUser=" + lastModifiedUser +
                ", operateUserName=" + operateUserName +
                ", fundMoneySum=" + fundMoneySum +
                ", button=" + button +
                '}';
    }
}
