package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingLinkRevertDao;
import com.pcloud.book.advertising.dto.LinkRevertRecordDTO;
import com.pcloud.book.advertising.entity.AdvertisingLinkRevert;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：链接转换记录
 * @作者：zhuyajie
 * @创建时间：16:54 2019/10/10
 * @版本：1.0
 */
@Component("advertisingLinkRevertDao")
public class AdvertisingLinkRevertDaoImpl extends BaseDaoImpl<AdvertisingLinkRevert> implements AdvertisingLinkRevertDao {

    @Override
    public List<LinkRevertRecordDTO> listRevertRecord(Long brandId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("brandId", brandId);
        return getSessionTemplate().selectList(getStatement("listRevertRecord"), paramMap);
    }

    @Override
    public List<AdvertisingLinkRevert> getAll() {
        return getSessionTemplate().selectList(getStatement("getAll"));
    }

    @Override
    public void updateLinkBrandData(AdvertisingLinkRevert linkRevert) {
        getSessionTemplate().update(getStatement("updateLinkBrandData"), linkRevert);
    }
}
