package com.pcloud.book.advertising.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.advertising.entity.AdvertisingBmOption;
import com.pcloud.book.advertising.entity.AdvertisingDetailFile;
import com.pcloud.common.dto.BaseDto;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @描述：CPA内容
 * @作者：zhuyajie
 * @创建时间：15:27 2019/9/4
 * @版本：1.0
 */
public class AdvertisingCpaDTO extends BaseDto {

    private Long id;
    /**
     *标题
     */
    private String detailName;
    /**
     *广告详情方式
     */
    private String detailMode;
    /**
     *广告详情封面
     */
    private String coverPic;
    /**
     *广告详情优惠图
     */
    private String welfarePic;
    /**
     * 广告详情介绍
     */
    private String detailInfo;
    /**
     *广告报名表单是否校验手机号
     */
    private Boolean formMobileCheck;
    /**
     *广告报名表单备注
     */
    private String formRemark;
    /**
     *广告报名表单提交按钮
     */
    private String formButton;
    /**
     *广告报名表单跳转链接
     */
    private String formLink;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;
    /**
     * 预览链接
     */
    private String previewLink;
    /**
     * 报名选项设置
     */
    private List<AdvertisingBmOption> advertisingBmOptionList;

    /**
     * 多个上传文件
     */
    private List<AdvertisingDetailFile> advertisingDetailFileList;

    /**
     * 曝光量
     */
    private Long exposureNum;
    /**
     * 点击量
     */
    private Long clickNum;
    /**
     * 点击率
     */
    private BigDecimal clickRate;
    /**
     * 点击用户数(独立访客数)
     */
    private Long clickUserNum;
    /**
     * 报名量
     */
    private Long registerNum;
    /**
     * 报名率
     */
    private BigDecimal registerRate;
    /**
     * 试听完成人数（完课量）
     */
    private Long pilotFinishUserNum;

    /**
     * 试听完成比率（完课率）
     */
    private BigDecimal pilotFinishRate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getDetailMode() {
        return detailMode;
    }

    public void setDetailMode(String detailMode) {
        this.detailMode = detailMode;
    }

    public String getCoverPic() {
        return coverPic;
    }

    public void setCoverPic(String coverPic) {
        this.coverPic = coverPic;
    }

    public String getWelfarePic() {
        return welfarePic;
    }

    public void setWelfarePic(String welfarePic) {
        this.welfarePic = welfarePic;
    }

    public String getDetailInfo() {
        return detailInfo;
    }

    public void setDetailInfo(String detailInfo) {
        this.detailInfo = detailInfo;
    }

    public Boolean getFormMobileCheck() {
        return formMobileCheck;
    }

    public void setFormMobileCheck(Boolean formMobileCheck) {
        this.formMobileCheck = formMobileCheck;
    }

    public String getFormRemark() {
        return formRemark;
    }

    public void setFormRemark(String formRemark) {
        this.formRemark = formRemark;
    }

    public String getFormButton() {
        return formButton;
    }

    public void setFormButton(String formButton) {
        this.formButton = formButton;
    }

    public String getFormLink() {
        return formLink;
    }

    public void setFormLink(String formLink) {
        this.formLink = formLink;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public List<AdvertisingBmOption> getAdvertisingBmOptionList() {
        return advertisingBmOptionList;
    }

    public void setAdvertisingBmOptionList(List<AdvertisingBmOption> advertisingBmOptionList) {
        this.advertisingBmOptionList = advertisingBmOptionList;
    }

    public List<AdvertisingDetailFile> getAdvertisingDetailFileList() {
        return advertisingDetailFileList;
    }

    public void setAdvertisingDetailFileList(List<AdvertisingDetailFile> advertisingDetailFileList) {
        this.advertisingDetailFileList = advertisingDetailFileList;
    }

    public String getPreviewLink() {
        return previewLink;
    }

    public void setPreviewLink(String previewLink) {
        this.previewLink = previewLink;
    }

    public Long getExposureNum() {
        return exposureNum;
    }

    public void setExposureNum(Long exposureNum) {
        this.exposureNum = exposureNum;
    }

    public Long getClickNum() {
        return clickNum;
    }

    public void setClickNum(Long clickNum) {
        this.clickNum = clickNum;
    }

    public BigDecimal getClickRate() {
        return clickRate;
    }

    public void setClickRate(BigDecimal clickRate) {
        this.clickRate = clickRate;
    }

    public Long getClickUserNum() {
        return clickUserNum;
    }

    public void setClickUserNum(Long clickUserNum) {
        this.clickUserNum = clickUserNum;
    }

    public Long getRegisterNum() {
        return registerNum;
    }

    public void setRegisterNum(Long registerNum) {
        this.registerNum = registerNum;
    }

    public BigDecimal getRegisterRate() {
        return registerRate;
    }

    public void setRegisterRate(BigDecimal registerRate) {
        this.registerRate = registerRate;
    }

    public Long getPilotFinishUserNum() {
        return pilotFinishUserNum;
    }

    public void setPilotFinishUserNum(Long pilotFinishUserNum) {
        this.pilotFinishUserNum = pilotFinishUserNum;
    }

    public BigDecimal getPilotFinishRate() {
        return pilotFinishRate;
    }

    public void setPilotFinishRate(BigDecimal pilotFinishRate) {
        this.pilotFinishRate = pilotFinishRate;
    }

    @Override
    public String toString() {
        return "AdvertisingCpaDTO{" +
                "id=" + id +
                ", detailName='" + detailName + '\'' +
                ", detailMode='" + detailMode + '\'' +
                ", coverPic='" + coverPic + '\'' +
                ", welfarePic='" + welfarePic + '\'' +
                ", detailInfo='" + detailInfo + '\'' +
                ", formMobileCheck=" + formMobileCheck +
                ", formRemark='" + formRemark + '\'' +
                ", formButton='" + formButton + '\'' +
                ", formLink='" + formLink + '\'' +
                ", updateTime=" + updateTime +
                ", previewLink='" + previewLink + '\'' +
                ", advertisingBmOptionList=" + advertisingBmOptionList +
                ", advertisingDetailFileList=" + advertisingDetailFileList +
                ", exposureNum=" + exposureNum +
                ", clickNum=" + clickNum +
                ", clickRate=" + clickRate +
                ", clickUserNum=" + clickUserNum +
                ", registerNum=" + registerNum +
                ", registerRate=" + registerRate +
                ", pilotFinishUserNum=" + pilotFinishUserNum +
                ", pilotFinishRate=" + pilotFinishRate +
                '}';
    }
}
