package com.pcloud.book.record.service.impl;

import com.pcloud.book.book.entity.Book;
import com.pcloud.book.record.biz.BookBrowseRecordBiz;
import com.pcloud.book.record.entity.BookBrowseRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName com.pcloud.book.record.service.impl.BookBrowseRecordServiceImpl
 * @Author 吴博
 * @Description 书籍浏览埋点内部接口实现类
 * @Date 2020/6/12 16:10
 * @Version 1.0
 **/
@RestController
@RequestMapping("bookBrowseRecordService")
public class BookBrowseRecordServiceImpl implements BookBrowseRecordService {

    @Autowired
    private BookBrowseRecordBiz bookBrowseRecordBiz;

    @Override
    @RequestMapping(value = "addBookRecord", method = RequestMethod.POST)
    public void addBookRecord(@RequestBody BookBrowseRecord bookBrowseRecord) {
        bookBrowseRecordBiz.addBookRecord(bookBrowseRecord);
    }

}