package com.pcloud.book.rightsSetting.dao.impl;

import com.pcloud.book.rightsSetting.dao.RightsSettingDAO;
import com.pcloud.book.rightsSetting.dto.RightsSettingDto;
import com.pcloud.book.rightsSetting.entity.RightsSetting;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class RightsSettingDAOImpl   extends BaseDaoImpl<RightsSetting> implements RightsSettingDAO{
    @Override
    public int deleteByPrimaryKey(Long id) {
        return super.getSqlSession().delete(getStatement("deleteByPrimaryKey"),id);
    }

    @Override
    public RightsSetting selectByPrimaryKey(Long id) {
        return super.getSqlSession().selectOne(getStatement("selectByPrimaryKey"),id);
    }

    @Override
    public int updateByPrimaryKeySelective(RightsSetting record) {
        return super.getSqlSession().update(getStatement("updateByPrimaryKeySelective"),record);
    }

    @Override
    public int updateByPrimaryKey(RightsSetting record) {
        return  super.getSqlSession().update(getStatement("updateByPrimaryKey"),record);
    }

    @Override
    public RightsSettingDto getByLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long volLabelId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("firstClassify",firstClassify);
        paramMap.put("secondClassify",secondClassify);
        paramMap.put("gradeLabelId",gradeLabelId);
        paramMap.put("subjectLabelId",subjectLabelId);
        paramMap.put("volLabelId", volLabelId);
        return getSessionTemplate().selectOne(getStatement("getByLabel"),paramMap);
    }

    @Override
    public RightsSettingDto getByBookId(Long bookId) {
        return getSessionTemplate().selectOne(getStatement("getByBookId"), bookId);
    }

    @Override
    public List<RightsSettingDto> listRightsSettingPage(Map<String, Object> map) {
        return getSessionTemplate().selectList(getStatement("listRightsSettingPage"),map);
    }
}
