package com.pcloud.book.skill.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.pcloud.book.applet.dto.AppletGroupStatementDTO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;

/**
 * @author zhengyongqiang
 * @date 2020/4/20 10:49
 */
@Data
@JsonInclude(Include.NON_NULL)
public class GroupActivity4AppletDTO implements Serializable {

    @ApiModelProperty("群类型 1：第三方群")
    private Integer groupType;

    private Long id;

    private Boolean openStatus;

    @ApiModelProperty("共读活动id")
    private Long groupActivityId;

    @ApiModelProperty("共度名称")
    private String name;

    @ApiModelProperty("描述")
    private String desc;

    @ApiModelProperty("描述")
    private String cutDesc;

    @ApiModelProperty("群图片，加群方式为图片时有效")
    private String groupPic;

    @ApiModelProperty("社群码id")
    private Long bookGroupQrcodeId;

    @ApiModelProperty("社群码名称")
    private String groupName;

    @ApiModelProperty("群人数")
    private Integer userNumber;

    @ApiModelProperty("群分类id")
    private Long classifyId;

    @ApiModelProperty("群id")
    private Long bookGroupId;

    @ApiModelProperty("头像列表")
    private List<String> headUrlList;

    @ApiModelProperty("权益标题")
    private String rightsSettingTitle;

    @ApiModelProperty("权益描述")
    private String rightsSettingDesc;

    @ApiModelProperty("学舍群话语")
    private List<AppletGroupStatementDTO> statementDTOList;

    @ApiModelProperty("群分类名称")
    private String classifyName;

    @ApiModelProperty("入群价格")
    private BigDecimal price;

    @ApiModelProperty("购买状态 1已购买 0未购买")
    private Integer status;

    @ApiModelProperty("关联社群书ID")
    private Long relatedBookGroupId;

    @ApiModelProperty("群链接")
    private String groupLink;
}
