package com.pcloud.book.skill.facade.request;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import com.pcloud.book.skill.entity.PcloudGroupActivity;
import com.pcloud.common.utils.string.StringUtil;

import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.beans.BeanUtils;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 修改共读活动
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("修改共读活动")
public class UpdateGroupActivityRequestVO extends BaseTempletClassify {

    private static final long serialVersionUID = 3642060073527485455L;

    @ApiModelProperty("编号")
    private String number;

    @ApiModelProperty("第三方入群链接")
    private String groupExtLink;

    @ApiModelProperty("群类型 0官方群 1第三方入群指引")
    private Integer groupType;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("共度名称")
    private String name;

    @ApiModelProperty("描述")
    private String desc;

    @ApiModelProperty("群图片，加群方式为图片时有效")
    private String groupPic;

    @ApiModelProperty("加群类型（0：邀请 1：图片）")
    private Integer joinType;

    @ApiModelProperty("专业标签")
    private Long proLabelId;

    @ApiModelProperty("深度标签")
    private Long depLabelId;

    @ApiModelProperty("目的标签")
    private Long purLabelId;

    @ApiModelProperty("群分类id")
    private Long bookGroupClassifyId;

    @ApiModelProperty("上下架")
    private Long isShow;

    public void checkParam() {
        if (null == id || StringUtil.isBlank(this.getName())
                || null == this.getProLabelId() || null == this.getDepLabelId()
                || null == this.getPurLabelId()
                || null == this.getGroupType()
                || null == this.getNumber()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请求参数缺失");
        }
        if("0".equals(this.getGroupType())){
            if (null == this.getJoinType()
                    || null == this.getBookGroupClassifyId()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "请求参数缺失");
            }
        }
    }

    /**
     * 转换实体映射
     */
    public PcloudGroupActivity getEntity() {
        PcloudGroupActivity pcloudGroupActivity = new PcloudGroupActivity();
        BeanUtils.copyProperties(this, pcloudGroupActivity);
        return pcloudGroupActivity;
    }

}
