package com.pcloud.common.utils.map;

/**
 * @描述：经纬度转换
 * @作者：lixing
 * @创建时间：2017年4月12日,下午17:30:19
 * @版本：1.0
 */
public class GpsConvert {
    public static double pi = 3.14159265358979324;
    public static double x_pi = pi * 3000.0 / 180.0;

    /**
     * 将 GCJ-02 坐标转换成 BD-09 坐标
     */
    public static void bd_encrypt(double gg_lat, double gg_lon, double[] latlng) {
        double x = gg_lon, y = gg_lat;
        double z = Math.sqrt(x * x + y * y) + 0.00002 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) + 0.000003 * Math.cos(x * x_pi);
        latlng[0] = z * Math.sin(theta) + 0.006;
        latlng[1] = z * Math.cos(theta) + 0.0065;
    }

    /**
     * 将 BD-09 坐标转换成 GCJ-02 坐标
     */
    public static void bd_decrypt(double bd_lat, double bd_lon, double[] latlng) {
        double x = bd_lon - 0.0065, y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 0.00002 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) - 0.000003 * Math.cos(x * x_pi);
        latlng[0] = z * Math.sin(theta);
        latlng[1] = z * Math.cos(theta);
    }
}
