package com.pcloud.common.utils.word.dto;

import java.util.List;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * @author：songx
 * @date：2017年12月7日,下午9:01:00
 */
@Getter
@Setter
@ToString(callSuper = true)
public class RunImageDTO extends RunDTO {

    /**
     * 图片地址，本地路径或者网络路径
     */
    private String imageUrl;

    /**
     * 图片byte数组
     */
    private byte[] imageByte;

    /**
     * 长度
     */
    private int height;

    /**
     * 宽度
     */
    private int width;

    /**
     * 前文本
     */
    private List<RunTextDTO> beforeTexts;

    /**
     * 后文本
     */
    private List<RunTextDTO> afterTexts;

    /**
     * 默认左对齐
     *
     * @param imageUrl
     * @param height
     * @param width
     */
    public static RunImageDTO newImage(String imageUrl, int height, int width) {
        return newImage(imageUrl, height, width, null, null);
    }

    /**
     * 默认左对齐
     *
     * @param imageUrl
     * @param height
     * @param width
     * @param beforeTexts
     * @param afterTexts
     */
    public static RunImageDTO newImage(String imageUrl, int height, int width, List<RunTextDTO> beforeTexts,
            List<RunTextDTO> afterTexts) {
        RunImageDTO runImageDTO = new RunImageDTO();
        runImageDTO.setImageUrl(imageUrl);
        runImageDTO.setHeight(height);
        runImageDTO.setWidth(width);
        runImageDTO.setBeforeTexts(beforeTexts);
        runImageDTO.setAfterTexts(afterTexts);
        return runImageDTO;
    }

}
