package com.pcloud.common.utils.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public final class CaffeineUtils {

    private CaffeineUtils() {
    }


    private static <K, V> void putAll(Cache<K, V> cache, Map<K, V> m) {
        if (MapUtils.isNotEmpty(m)) {
            cache.putAll(m);
        }
    }

    public static <K, V> Map<K, V> getByCache(Cache<K, V> cache, List<K> keyList, Function<Set<K>, Map<K, V>> function) {
        Map<K, V> result = new HashMap<>();
        if (CollectionUtils.isEmpty(keyList)) {
            return result;
        }

        Set<K> needQueryIds = new HashSet<>();
        Map<K, V> mapInCache = new HashMap<>();
        keyList.forEach((key) -> {
            V cacheValue = cache.getIfPresent(key);
            if (cacheValue != null) {
                mapInCache.put(key, cacheValue);
            } else {
                needQueryIds.add(key);
            }
        });
        if (CollectionUtils.isEmpty(needQueryIds)) {
            return mapInCache;
        }

        Map<K, V> queryResult = function.apply(needQueryIds);

        // 放入缓存
        putAll(cache, queryResult);

        // 汇总结果集合
        result.putAll(mapInCache);
        result.putAll(queryResult);

        return result;
    }

    public static <K, V> Optional<V> getByCache(Cache<K, V> cache, K key, Supplier<V> supplier) {
        if (key == null) {
            return Optional.empty();
        }

        V cacheValue = cache.getIfPresent(key);
        if (cacheValue != null) {
            return Optional.of(cacheValue);
        }

        V queryResult = supplier.get();
        if (queryResult != null) {
            // 放入缓存
            cache.put(key, queryResult);
        }

        return Optional.ofNullable(queryResult);
    }
}
