package com.pcloud.common.utils.word.dto;

import org.apache.poi.xwpf.usermodel.XWPFTableCell.XWPFVertAlign;

import lombok.Getter;
import lombok.Setter;

/**
 * @author：songx
 * @date：2017年12月7日,下午4:02:41
 */
@Getter
@Setter
public class RunTableDTO extends RunDTO {

    /**
     * 列宽,默认100
     */
    private float[] columnWidths;

    /**
     * 列的内容
     */
    private String[][] contents;

    /**
     * 设置单元格高度，仅当表格的时候使用
     */
    private float minimumHeight;

    /**
     * 高度
     */
    private int height;

    /**
     * 表格对齐
     */
    private XWPFVertAlign vertAlign;

    /**
     * 2007版word
     *
     * @param contents
     * @param height
     * @param vertAlign
     */
    public RunTableDTO(String[][] contents, int height, XWPFVertAlign vertAlign) {
        this.contents = contents;
        this.height = height;
        this.vertAlign = vertAlign;
    }

}
