package com.pcloud.book.applet.dto;



import com.pcloud.book.applet.entity.AppletUserLabel;
import com.pcloud.book.applet.entity.AppletUserLabelRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;
import org.springframework.beans.BeanUtils;

/**
 * @ClassName com.pcloud.book.applet.dto.AppletUserLabelDTO
 * @Author 吴博
 * @Description 客户端标签
 * @Date 2020/5/18 9:14
 * @Version 1.0
 **/
@ApiModel
@Data
public class AppletUserLabelDTO {
    private Long id;

    @ApiModelProperty("客户端标签名称")
    @NotNull(message = "标签名称不能为空")
    private String labelName;

    @ApiModelProperty("客户端分类id")
    @NotNull(message = "客户端分类id不能为空")
    private Long appletBookClassifyId;

    @ApiModelProperty("关联年级及科目标签")
    private List<AppletUserLabelRelation> appletUserLabelRelations;

    public AppletUserLabel DTOToEntity() {
        AppletUserLabel appletUserLabel = new AppletUserLabel();
        BeanUtils.copyProperties(this, appletUserLabel);
        return appletUserLabel;
    }

    @ApiModelProperty("出版社id")
    private Long agentId;

}