package com.pcloud.book.applet.service;


import com.pcloud.book.applet.dto.AppletAppOrProductDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.dto.AppletNewsVO;
import com.pcloud.book.applet.dto.AppletOuterBookDTO;
import com.pcloud.book.applet.dto.AppletOuterBooklistDTO;
import com.pcloud.book.applet.dto.AppletThirdResourcesDTO;
import com.pcloud.book.applet.dto.PcloudGroupActivityDTO;
import com.pcloud.book.applet.dto.ServeCollectDTO;
import com.pcloud.common.dto.ResponseDto;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.util.List;
import java.util.Map;

@FeignClient(value = "pcloud-service-book", qualifier = "appletServiceCloud", path = "book/v1.0/appletService")
@Api(description = "小程序内部接口")
public interface AppletService {


    @ApiOperation("根据资讯id查资讯")
    @GetMapping("getNewsById")
    public ResponseEntity<ResponseDto<AppletNewsVO>> getNewsById(@RequestParam("newsId") Long newsId);

    //add by pansy 2020/07/02
    @ApiOperation("根据第三方群id获取信息")
    @GetMapping("getGroupActivityById")
    public ResponseEntity<ResponseDto<PcloudGroupActivityDTO>> getGroupActivityById(@RequestParam("id") Long id);

    @ApiOperation("根据id查外部书刊")
    @GetMapping("getOuterBookById")
    public ResponseEntity<ResponseDto<AppletOuterBookDTO>> getOuterBookById(@RequestParam("outerBookId") Long outerBookId);

    @ApiOperation("给出版分配小睿基本书刊分类")
    @GetMapping("createBaseClassifysToAgent")
    void createBaseClassifysToAgent(@RequestParam("agentId") @ApiParam Long agentId);

    @ApiOperation("检测订阅的书籍答案有更新")
    @GetMapping("checkAnswerUpdate")
    void checkAnswerUpdate();

    @ApiOperation("定时推送答案订阅提醒")
    @GetMapping("sendAppletMsg4Answer")
    void sendAppletMsg4Answer();

    @ApiOperation("获取第三方跟谁学统计数据")
    @GetMapping("getAppletThirdResourceStatic")
    void getAppletThirdResourceStatic(@RequestParam(value = "isAll", required = false) @ApiParam Integer isAll);

    /**
     * 查询是否是否存在
     * @param serveCollects
     * @return
     */
    @PostMapping("getList4Collect")
    ResponseEntity<ResponseDto<List<ServeCollectDTO>>> getList4Collect(@RequestBody List<ServeCollectDTO> serveCollects);

    @ApiOperation("查弹窗弹出次数")
    @GetMapping("getPopupCount")
    ResponseEntity<ResponseDto<Integer>> getPopupCount(@RequestParam("wechatUserId") Long wechatUserId,
                                                       @RequestParam("bookId") Long bookId,
                                                       @RequestParam("popupType") Integer popupType);

    @ApiOperation("删除指定周的统计数据")
    @GetMapping("deleteWeekAppletRecordStatis")
    void deleteWeekAppletRecordStatis(@RequestParam("mondayDate")String mondayDate);

    @ApiOperation("统计指定周的数据")
    @GetMapping("addWeekAppletRecordStatis")
    void addWeekAppletRecordStatis(@RequestParam("mondayDate")String mondayDate);

    @ApiOperation("获取资讯map")
    @PostMapping("getNewsByIds")
    ResponseEntity<ResponseDto<Map<Long, AppletNewsDTO>>> getNewsByIds(@RequestBody List<Long> newsIds);


    @ApiOperation("获取书单")
    @PostMapping("getOuterBooklistByIds")
    ResponseEntity<ResponseDto<Map<Long, AppletOuterBooklistDTO>>> getOuterBooklistByIds(@RequestBody List<Long> bookRecommendIds);

    @ApiOperation("获取用户所有收藏")
    @GetMapping("getAllCollectServe")
    ResponseEntity<ResponseDto<List<ServeCollectDTO>>> getAllCollectServe(@RequestParam("wechatUserId") Long wechatUserId);


    @ApiOperation("从足迹获取应用或作品浏览人数")
    @PostMapping("getAppOrProductBrowseCount")
    ResponseEntity<ResponseDto<Map<Long, AppletAppOrProductDTO>>> getAppOrProductBrowseCount(@RequestParam("recordType") Integer recordType,
                                                                                             @RequestBody List<Long> serveIds);


    @ApiOperation("mySql 足迹数据同步到 clickHouse")
    @GetMapping("fixAppletRecordDataSync4CH")
    void fixAppletRecordDataSync4CH(@RequestParam(value = "createDate", required = false) String createDate);

    @ApiOperation("并更新缓存")
    @GetMapping("updateAggrStatisCache")
    void updateAggrStatisCache();

    @ApiOperation("mySql 足迹数据同步到 clickHouse，并更新缓存")
    @GetMapping("syncDataAndUpdateCache")
    void syncDataAndUpdateCache(@RequestParam(value = "createDate", required = false) String createDate);

    @ApiOperation("更新 applet_record.type_code 旧数据")
    @GetMapping("handleAppletRecordTypeCode")
    ResponseEntity<ResponseDto<Object>> handleAppletRecordTypeCode(@RequestParam(value = "lastAppletRecordId", required = false) Long lastAppletRecordId);

    @ApiOperation("停止更新 applet_record.type_code 旧数据")
    @GetMapping("stopHandleAppletRecordTypeCode")
    void stopHandleAppletRecordTypeCode();

    @ApiOperation("定时任务更新banner上下架状态")
    @GetMapping("autoChageBannerState")
    void autoChageBannerState(@RequestParam("id") Long id,
                              @RequestParam("showState") Integer showState);

    @ApiOperation("定时任务从redis中删掉超时的本书服务记录")
    @GetMapping("autoDeleteReadBook")
    void autoDeleteReadBook();

    @ApiOperation("查询第三方资源")
    @GetMapping("getThirdResourceById")
    ResponseEntity<ResponseDto<AppletThirdResourcesDTO>> getThirdResourceById(@RequestParam("thirdResourcesId") Long thirdResourcesId);

}
