package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

import lombok.Data;

/**
 * 书刊保底支持(BookMinimumSupport)实体类
 *
 * @author makejava
 * @since 2020-12-31 16:47:20
 */
@Data
public class BookMinimumSupportDTO extends BaseDto {
    private static final long serialVersionUID = -37536073957919349L;
    /**
    * 主键
    */
    private Long id;
    /**
    * 书刊id
    */
    private Long bookId;
    /**
    * 保底开始时间
    */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;
    /**
    * 保底结束时间
    */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;
    /**
    * 印册量
    */
    private Integer printAmount;
    /**
    * 备注
    */
    private String remark;
    /**
    * 创建人
    */
    private Long createUser;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
}