package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * ERP 图书印册量
 */
@Data
@ApiModel("ERP 图书印册量")
public class ERPPublishNumDTO {
    @ApiModelProperty("编辑ID")
    private Long adviserId;
    @ApiModelProperty("渠道ID")
    private Long channelId;
    @ApiModelProperty("图书ID")
    private Long bookId;
    @ApiModelProperty("印册量")
    private Long expectPublishNum;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;
}
