package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class QrcodeServeDto implements Serializable {

    @ApiModelProperty("作品或应用id")
    private Long serveId;

    @ApiModelProperty("sceneId")
    private Long sceneId;

    @ApiModelProperty("社群书id")
    private Long bookGroupId;

    @ApiModelProperty("类型；APP应用，PRODUCT作品")
    private String serveType;

    @ApiModelProperty("链接")
    private String serveUrl;

    @ApiModelProperty("短链")
    private String shortUrl;

    @ApiModelProperty("应用或作品名称")
    private String serveName;

    @ApiModelProperty("类型")
    private String fromType;

    @ApiModelProperty("是否超级作者")
    private Boolean isSuper;

    @ApiModelProperty("销售价")
    private Double retailPrice;

    @ApiModelProperty("协议价")
    private Double dealPrice;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("描述信息")
    private String description;

    @ApiModelProperty("类型")
    private String typeCode;

    @ApiModelProperty("唯一码")
    private String uniqueNumber;

    @ApiModelProperty("专业")
    private Long proLabelId;

    @ApiModelProperty("深度")
    private Long depLabelId;

    @ApiModelProperty("目的")
    private Long purLabelId;

    @ApiModelProperty("专业")
    private String proLabelName;

    @ApiModelProperty("深度")
    private String depLabelName;

    @ApiModelProperty("目的")
    private String purLabelName;

    @ApiModelProperty("服务创建人")
    private Long serveCreateUser;

    @ApiModelProperty("服务创建人名称")
    private String serveCreateUserName;

    @ApiModelProperty("横图")
    private String transverseImg;;
}
