package com.pcloud.book.book.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * ERP自动创建二维码临时表，由于没有 adviserId，所以无法创建二维码，将数据暂存，关联时再创建(QrcodeSceneErp)实体类
 *
 * @author makejava
 * @since 2020-08-26 21:01:47
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QrcodeSceneErp extends BaseEntity {

    private static final long serialVersionUID = 462217150676961069L;
    
    @ApiModelProperty("场景标识")
    private Long sceneErpId;
    
    @ApiModelProperty("场景编码")
    private String sceneCode;
    
    @ApiModelProperty("书籍标识")
    private Long bookId;
    
    private Long adviserBookId;
    
    @ApiModelProperty("图书名称")
    private String bookName;
    
    @ApiModelProperty("是否有省份配置数据")
    private Boolean haveProvinceMessage;
    
    @ApiModelProperty("素材标识")
    private Long materialLibId;
    
    @ApiModelProperty("场景名称")
    private String sceneName;
    
    @ApiModelProperty("二维码图片url")
    private String qrcodeUrl;
    
    @ApiModelProperty("场景说明")
    private String description;
    
    @ApiModelProperty("渠道标识")
    private Long channelPartyId;
    
    @ApiModelProperty("公众号标识")
    private Long accountSettingId;
    
    @ApiModelProperty("0未删除 1已删除")
    private String isDelete;
    
    @ApiModelProperty("是否已被从回收站中删除，“0”未删除，“1”已删除")
    private String isDeleteRecycleBin;
    
    @ApiModelProperty("图书是否删除 1 已删除 0 未删除")
    private Boolean isBookDelete;
    
    @ApiModelProperty("二维码图片解析后的地址")
    private String url;
    
    @ApiModelProperty("创建人角色")
    private String createdUserRole;
    
    @ApiModelProperty("顾问标识")
    private Long adviserId;
    
    @ApiModelProperty("用途类型")
    private String purposeType;
    
    @ApiModelProperty("二维码类型（wechat：微信码 ali：支付宝码）")
    private String qrcodeType;
    
    @ApiModelProperty("模板标识")
    private Long templetId;
    
    @ApiModelProperty("来源(1 PC 2 wechat 3 app 4 小程序)")
    private Integer clientCode;
    
    @ApiModelProperty("创建人")
    private Long createdByUserLogin;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createdDate;
    
    @ApiModelProperty("修改人")
    private Long lastModifiedByUserLogin;
    
    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastModifiedDate;
    
    @ApiModelProperty("版本")
    private Integer version;
    
    @ApiModelProperty("审核状态")
    private String auditState;
    
    @ApiModelProperty("审核人")
    private Long auditUser;
    
    @ApiModelProperty("审核时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date auditDate;
    
    @ApiModelProperty("审核原因")
    private String auditReason;
    
    @ApiModelProperty("审核提交时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date auditSubmitDate;
    
    @ApiModelProperty("二维码推送封面图")
    private String coverImg;
    
    @ApiModelProperty("公众号二维码")
    private Boolean isOpenApp;

    private Integer locationPageNum;

    @ApiModelProperty(value = "专业标签标识", dataType = "Long")
    private Long proLabelId;

    @ApiModelProperty(value = "深度标签标识", dataType = "Long")
    private Long depLabelId;

    @ApiModelProperty(value = "目的标签标识", dataType = "Long")
    private Long purLabelId;

    @ApiModelProperty(value = "印码位置标识", dataType = "Long")
    private Long locationId;

}
