package com.pcloud.book.copyright.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lily
 * @date 2018/12/17 11:12
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookAuthInfoCountDTO implements Serializable {

    private static final long serialVersionUID = -279583394937791724L;
    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("购买数量")
    private Integer payUserCount;

    @ApiModelProperty("使用正版授权码数量")
    private Integer codeUserCount;

    @ApiModelProperty("开启时间")
    private Date openTime;

    @ApiModelProperty("关闭时间")
    private Date closeTime;

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getOpenTime() {
        return openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Integer getPayUserCount() {
        return payUserCount;
    }

    public void setPayUserCount(Integer payUserCount) {
        this.payUserCount = payUserCount;
    }

    public Integer getCodeUserCount() {
        return codeUserCount;
    }

    public void setCodeUserCount(Integer codeUserCount) {
        this.codeUserCount = codeUserCount;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    @Override
    public String toString() {
        return "BookAuthInfoCountDTO{" +
                "bookId=" + bookId +
                ", channelId=" + channelId +
                ", adviserId=" + adviserId +
                ", payUserCount=" + payUserCount +
                ", codeUserCount=" + codeUserCount +
                ", openTime=" + openTime +
                ", closeTime=" + closeTime +
                '}';
    }
}
