package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;
import java.util.List;

/**
 * @描述：个人号读者统计
 * @作者：zhuyajie
 * @创建时间：10:32 2019/11/11
 * @版本：1.0
 */
public class SelfRobotUserDTO extends BaseDto {

    /**
     * 微信用户ID
     */
    private String wxUserId;

    /**
     * 个人号id
     */
    private String robotId;
    /**
     * 扫码书刊
     */
    private List<BookDto> bookList;
    /**
     * 加好友时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date joinTime;

    public String getWxUserId() {
        return wxUserId;
    }

    public void setWxUserId(String wxUserId) {
        this.wxUserId = wxUserId;
    }

    public String getRobotId() {
        return robotId;
    }

    public void setRobotId(String robotId) {
        this.robotId = robotId;
    }

    public List<BookDto> getBookList() {
        return bookList;
    }

    public void setBookList(List<BookDto> bookList) {
        this.bookList = bookList;
    }

    public Date getJoinTime() {
        return joinTime;
    }

    public void setJoinTime(Date joinTime) {
        this.joinTime = joinTime;
    }
}
