package com.pcloud.book.timecontrol.dto;

import io.swagger.annotations.ApiParam;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @Description：TODO
 * @Author：zcy
 * @Date：2020-01-30
 * @Version：1.0
 */
@Data
public class UpdateTaskDto implements Serializable {

    @NotNull(message = "任务ID缺失")
    private Integer taskId;
    @NotNull(message = "任务名称不能为空")
    @Size(max = 20)
    private String taskName;
    @Size(max = 300)
    @NotNull(message = "任务引导语不能为空")
    private String taskIntroduce;
    @Size(max = 20)
    @NotNull(message = "订阅方式不能为空")
    private String subscribeWord;

    private Integer advancedSetting;

    private Long depLabelId;

    private Long purLabelId;

    private Long proLabelId;

    //1按天发送  2按周发送
    private Integer sendType;

}
