package com.pcloud.book.adnews.dao;

import com.pcloud.book.adnews.entity.AdNewsWechat;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @author zhengyongqiang
 * @date 2019/8/7 11:46
 */
public interface AdNewsWechatDao extends BaseDao<AdNewsWechat> {

    boolean checkRepeat(String wechatName, Long adviserId);

    /**
     * 批量新增自有公众号
     * @param list
     * @return
     */
    Integer batchInsert(List<AdNewsWechat> list);

    /**
     * 检测是否存在自有公众号
     * @param adviserId
     * @return
     */
    boolean existsAdNewsWechat(Long adviserId);

    /**
     * 获取自有公众号
     * @param adviserId
     * @return
     */
    List<AdNewsWechat> getListByAdviserId(Long adviserId);
}
