package com.pcloud.book.adnews.dao.impl;

import com.pcloud.book.adnews.dao.AdNewsDao;
import com.pcloud.book.adnews.entity.AdNews;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/17 16:16
 **/
@Repository("adNewsDao")
public class AdNewsDaoImpl extends BaseDaoImpl<AdNews> implements AdNewsDao {
    @Override
    public List<AdNews> getNewsToSendBySetIdAndAdviser(Long adNewsSetId, Long adviserId, Integer top) {
        Map<String, Object> map = new HashMap<>();
        map.put("adNewsSetId", adNewsSetId);
        map.put("adviserId", adviserId);
        map.put("top", top);
        return super.getSqlSession().selectList(getStatement("getNewsToSendBySetIdAndAdviser"), map);
    }

    @Override
    public List<AdNews> getNewsToSendBySetIdAndAdviser4Own(Long adNewsSetId, Long adviserId, Integer top) {
        Map<String, Object> map = new HashMap<>();
        map.put("adNewsSetId", adNewsSetId);
        map.put("adviserId", adviserId);
        map.put("top", top);
        return super.getSqlSession().selectList(getStatement("getNewsToSendBySetIdAndAdviser4Own"), map);
    }

    @Override
    public List<AdNews> getNewsByLabelName(Long adNewsSetId, Long adviserId, String beginTime, String proLabelName, String depLabelName, String purLabelName, Integer top) {
        Map<String, Object> map = new HashMap<>();
        map.put("adNewsSetId", adNewsSetId);
        map.put("adviserId", adviserId);
        map.put("beginTime", beginTime);
        map.put("proLabelName", proLabelName);
        map.put("depLabelName", depLabelName);
        map.put("purLabelName", purLabelName);
        map.put("top", top);
        return super.getSqlSession().selectList(getStatement("getNewsByLabelName"), map);
    }

    @Override
    public List<AdNews> getNews4WechatByLabelName(Long adNewsSetId, Long adviserId,String beginTime, String proLabelName, String depLabelName, String purLabelName, Integer top) {
        Map<String, Object> map = new HashMap<>();
        map.put("adNewsSetId", adNewsSetId);
        map.put("adviserId", adviserId);
        map.put("beginTime", beginTime);
        map.put("proLabelName", proLabelName);
        map.put("depLabelName", depLabelName);
        map.put("purLabelName", purLabelName);
        map.put("top", top);
        return super.getSqlSession().selectList(getStatement("getNews4WechatByLabelName"), map);
    }
}
