package com.pcloud.book.advertising.dao;

import java.util.Map;
import com.pcloud.book.advertising.entity.AdvertisingIncomeDaily;
import com.pcloud.common.core.dao.BaseDao;

/**
 * Description 广告位每日收益统计数据访问层接口
 * Created by PENG on 2019/5/6.
 */
public interface AdvertisingIncomeDailyDao extends BaseDao<AdvertisingIncomeDaily> {

    /**
     * 插入扫社群码页面和作品/应用广告位的昨日收益数据
     * @param paramMap 参数Map
     * @return
     */
    long insertRecordWithoutWechatGroupMsgAd(Map<String, Object> paramMap);

    /**
     * 插入微信群消息广告位的昨日收益数据
     * @param paramMap 参数Map
     * @return
     */
    long insertWechatGroupMsgAdRecord(Map<String, Object> paramMap);
}
