package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.dto.AdvertisingDistributionDTO;
import com.pcloud.book.advertising.entity.AdvertisingPut;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface AdvertisingPutDao extends BaseDao<AdvertisingPut> {
    Integer batchInsert(List<AdvertisingPut> advertisingPuts);

    /**
     * 根据计划id查询
     */
    List<AdvertisingPut> getListByPlanId(Long planId);

    /**
     * 根据id集合删除
     */
    void deleteByIds(List<Long> ids, Long partyId);

    /**
     * 根据计划id结合查询
     */
    List<AdvertisingPut> getListByPlanIds(List<Long> planIds);

    /**
     * 根据时间查发送计划
     * @param adId
     * @param qrcodeId
     * @param dateTime
     * @param timeOnly
     * @return
     */
    public AdvertisingDistributionDTO getPlanByTime(Long adId, Long qrcodeId, String dateTime, String timeOnly, String dateOnly);
}
